/*
 * Decompiled with CFR 0.152.
 */
package nccloud.web.fip.billitem.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.billitem.IFipBillItemService;
import nc.vo.fip.billitem.BillItemVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.ml.NCLangRes4VoTransl;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.pattern.GridConvertor;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billgrid.BillGrid;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class QueryBillitemAction
implements ICommonAction {
    public Object doAction(IRequest request) {
        try {
            Object[] vos;
            String str = request.read();
            IJson json = JsonFactory.create();
            QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(str, QueryTemplateInfo4Web.class);
            BillItemVO vo = new BillItemVO();
            if (info.getOid() != null) {
                vo.setPk_billtype(info.getOid());
            }
            String pid = null;
            String isFiter = null;
            if (info.getConditions() != null && info.getConditions().size() > 0) {
                Conditions condition = (Conditions)info.getConditions().get(0);
                if ("isfiter".equals(condition.getField())) {
                    isFiter = condition.getValue().getFirstvalue();
                } else {
                    pid = condition.getValue().getFirstvalue();
                }
            }
            if ((vos = ((IFipBillItemService)ServiceLocator.find(IFipBillItemService.class)).queryByVO(vo)) == null) {
                vo.setPk_billtype(pid);
                vos = ((IFipBillItemService)ServiceLocator.find(IFipBillItemService.class)).queryByVO(vo);
            }
            if (vos != null && "DL".equalsIgnoreCase(vo.getPk_billtype()) && "Y".equals(isFiter)) {
                vos = ((IFipBillItemService)ServiceLocator.find(IFipBillItemService.class)).fiterBillItemsByAttCfg(vo.getPk_billtype(), (BillItemVO[])vos);
            }
            int currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq();
            if (vos == null || vos.length == 0) {
                return null;
            }
            for (BillItemVO billItemVO : vos) {
                if (currLangIndex == 1) {
                    billItemVO.setExplanation(billItemVO.getExplanation());
                    continue;
                }
                if (billItemVO.getAttributeValue("explanation" + currLangIndex) != null) {
                    billItemVO.setExplanation((String)billItemVO.getAttributeValue("explanation" + currLangIndex));
                }
                if (billItemVO.getAttributeValue("attrname" + currLangIndex) == null) continue;
                billItemVO.setAttrname(billItemVO.getAttributeValue("attrname" + currLangIndex).toString());
            }
            GridConvertor convertor1 = new GridConvertor();
            GridConvertor convertor2 = new GridConvertor();
            Grid grid1 = convertor1.toGrid("billitem", vos);
            BillItemVO billItemVO = new BillItemVO();
            billItemVO.setAttrcode(NCLangRes4VoTransl.getNCLangRes().getStrByID("10170202", "1101702020002"));
            Grid grid2 = convertor2.toGrid("billitem2", (Object[])new BillItemVO[]{billItemVO});
            String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            HashSet<String> set = new HashSet<String>();
            Row[] rows = grid1.getModel().getRows();
            if (rows != null && rows.length > 0) {
                for (Row row : rows) {
                    Cell cell = (Cell)row.getValues().get("entity_attr");
                    if (cell == null || cell.getValue() == null) continue;
                    set.add((String)cell.getValue());
                }
                Map map = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertBillItemData(set, pk_group, "TX01");
                for (Row row : rows) {
                    Cell cell = (Cell)row.getValues().get("entity_attr");
                    if (cell == null || cell.getValue() == null || map.get(cell.getValue()) == null) continue;
                    cell.setDisplay((String)map.get(cell.getValue()));
                }
            }
            BillGrid bgrid = new BillGrid();
            bgrid.setHead(grid1);
            bgrid.setBody(grid2);
            bgrid.setTempletid("0001Z31000000001HQGH");
            bgrid.setPageid("10170290_1017029001");
            Translator translator = new Translator();
            translator.translate(bgrid);
            ArrayList<Grid> grids = new ArrayList<Grid>();
            grids.add(grid1);
            grids.add(grid2);
            return grids;
        }
        catch (Exception e) {
            ExceptionUtils.wrapException((Throwable)e);
            return null;
        }
    }
}

