package nccloud.web.fip.voucherattrcfg.action;

import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.voucherattrcfg.IVoucherAttrCfgService;
import nc.vo.fip.voucherattrcfg.VoucherAttrVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class QueryVoucherAttrCfgAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         VoucherAttrVO vo = new VoucherAttrVO();
         if(info.getOid() != null) {
            vo.setPk_billtype(info.getOid());
         }

         vo.setPk_group(pk_group);
         VoucherAttrVO[] vos = ((IVoucherAttrCfgService)ServiceLocator.find(IVoucherAttrCfgService.class)).queryVoucherAttrByVO(vo);
         if(vos == null) {
            return null;
         } else {
            GridConvertProcessor processor = new GridConvertProcessor();
            Grid grid = processor.convert(info.getPageCode(), vos);
            HashSet txset = new HashSet();
            HashSet dlset = new HashSet();
            Row[] rows = grid.getModel().getRows();
            Cell txcell = null;
            Cell dlcell = null;
            if(rows != null && rows.length > 0) {
               Row[] translator = rows;
               int dlmap = rows.length;

               for(int var17 = 0; var17 < dlmap; ++var17) {
                  Row row = translator[var17];
                  txcell = (Cell)row.getValues().get("txbill");
                  if(txcell != null && txcell.getValue() != null) {
                     txset.add((String)txcell.getValue());
                  }

                  dlcell = (Cell)row.getValues().get("detailbook");
                  if(dlcell != null && dlcell.getValue() != null) {
                     dlset.add((String)dlcell.getValue());
                  }
               }

               Map var22 = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertBillItemData(txset, pk_group, "TX01");
               Map var24 = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertBillItemData(dlset, pk_group, "DL");
               Row[] var25 = rows;
               int var26 = rows.length;

               for(int var19 = 0; var19 < var26; ++var19) {
                  Row row1 = var25[var19];
                  txcell = (Cell)row1.getValues().get("txbill");
                  if(txcell != null && txcell.getValue() != null && var22.get(txcell.getValue()) != null) {
                     txcell.setDisplay((String)var22.get(txcell.getValue()));
                  }

                  dlcell = (Cell)row1.getValues().get("detailbook");
                  if(dlcell != null && dlcell.getValue() != null && var24.get(dlcell.getValue()) != null) {
                     dlcell.setDisplay((String)var24.get(dlcell.getValue()));
                  }
               }
            }

            Translator var23 = new Translator();
            var23.translate(grid);
            return grid;
         }
      } catch (Exception var21) {
         ExceptionUtils.wrapException(var21);
         return null;
      }
   }
}
