package nccloud.web.fip.txmsgdata.action;

import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class QueryTXDataShowColumnAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);

      try {
         BilltypeVO e = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).queryByPk(info.getSrc_billtype());
         if(e != null) {
            if(e.istransaction.booleanValue()) {
               info.setSrc_billtype(e.getParentbilltype());
            } else {
               info.setSrc_billtype(e.getPk_billtypecode());
            }
         }

         return ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).requireTXDataShowColumn(info.getSrc_billtype());
      } catch (BusinessException var6) {
         ExceptionUtils.wrapException(var6);
         return null;
      }
   }
}
