package nccloud.web.fip.txmsgdata.action;

import java.util.ArrayList;
import java.util.List;
import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.web.fip.txmsgdata.action.CommonInfo;

public class QueryPageAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      CommonInfo info = (CommonInfo)json.fromJson(str, CommonInfo.class);
      AggTXBillVO[] vos = null;
      Grid grid = null;

      try {
         String[] e = info.getRelationIDs();
         if(e != null && e.length > 0) {
            vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsBySrcRelationIDs(e);
            vos = this.sort(vos, e, "relationid");
         } else {
            vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsByPKs(info.getPk_bills());
            vos = this.sort(vos, info.getPk_bills(), "pk_txbill");
         }

         if(vos != null) {
            TXBillVO[] parent = new TXBillVO[vos.length];

            for(int operator = 0; operator < vos.length; ++operator) {
               parent[operator] = vos[operator].getParentVO();
            }

            GridOperator var11 = new GridOperator(info.getPageId());
            grid = var11.toGrid(parent);
            this.processBillGridBillType(grid, parent);
         }
      } catch (Exception var10) {
         ExceptionUtils.wrapException(var10);
      }

      return grid;
   }

   private AggTXBillVO[] sort(AggTXBillVO[] param1, String[] param2, String param3) {
      // $FF: Couldn't be decompiled
   }

   private void processBillGridBillType(Grid grid, TXBillVO[] heads) throws BusinessException {
      Row[] rows = grid.getModel().getRows();

      for(int i = 0; i < rows.length; ++i) {
         Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
         Cell cell2 = rows[i].getCell("pk_srctradetypeid");
         String pk_currbilltype = null;
         if(cell2 != null && cell2.getValue() != null) {
            pk_currbilltype = String.valueOf(cell2.getValue());
         } else {
            pk_currbilltype = String.valueOf(cell1.getValue());
         }

         BilltypeVO billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
         Cell pkSystemCell;
         if(billType != null) {
            pkSystemCell = new Cell();
            if(billType.istransaction != null && billType.istransaction.booleanValue()) {
               String parentTypeCode = billType.getParentbilltype();
               billType.getPk_billtypecode().setValue(parentTypeCode);
               if(StringUtils.isBlank(cell2.getDisplay())) {
                  cell2.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }

               if(StringUtils.isBlank(cell1.getDisplay())) {
                  BilltypeVO parentBillType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(parentTypeCode);
                  if(parentBillType != null) {
                     cell1.setDisplay(FipLangTool.getCurrLangValue(parentBillType, "billtypename"));
                  }
               }
            } else {
               pkSystemCell.setValue(billType.getPk_billtypecode());
               if(StringUtils.isBlank(cell1.getDisplay())) {
                  cell1.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }
            }

            pkSystemCell.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
            rows[i].addCell("pk_currbilltype", pkSystemCell);
         }

         pkSystemCell = rows[i].getCell("pk_system");
         if(pkSystemCell.getValue() != null && "EM".equals(pkSystemCell.getValue())) {
            pkSystemCell.setValue(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
         }

         if(pkSystemCell.getValue() != null && "YXY".equals(pkSystemCell.getValue())) {
            pkSystemCell.setValue(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
         }

         rows[i].addCell("pk_system", pkSystemCell);
      }

   }

   // $FF: synthetic method
   private static List lambda$sort$0(String k) {
      return new ArrayList();
   }
}
