package nccloud.web.fip.txmsgdata.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.CloudFusionUtil;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillItemVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.CircularlyAccessibleValueObject;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.form.Form;
import nccloud.web.fip.txmsgdata.action.CommonInfo;

public class QueryCardAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      CommonInfo info = (CommonInfo)json.fromJson(str, CommonInfo.class);
      AggTXBillVO[] vos = null;
      BillCard retcard = null;

      try {
         String e = info.getRelationID();
         if(e != null) {
            vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsBySrcRelationIDs(new String[]{e});
         } else {
            vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).queryBillsByPKs(new String[]{info.getPk_bill()});
         }

         if(vos != null && vos.length > 0) {
            AggTXBillVO[] var8 = vos;
            int var9 = vos.length;

            for(int var10 = 0; var10 < var9; ++var10) {
               AggTXBillVO aggTXBillVO = var8[var10];
               HashMap bodyMap = new HashMap();
               TXBillVO parent = (TXBillVO)aggTXBillVO.getParent();
               if(parent != null && "EM".equals(parent.getPk_system())) {
                  parent.setPk_system(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
               }

               if(parent != null && "YXY".equals(parent.getPk_system())) {
                  parent.setPk_system(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
               }

               TXBillItemVO[] items = aggTXBillVO.getBodyVOs();
               if(ArrayUtils.isNotEmpty(items)) {
                  TXBillItemVO[] keylist = items;
                  int bodyList = items.length;

                  for(int var17 = 0; var17 < bodyList; ++var17) {
                     TXBillItemVO key = keylist[var17];
                     Integer item = key.getRowno();
                     bodyMap.put(item, key);
                  }
               }

               ArrayList var21 = new ArrayList();
               var21.addAll(bodyMap.keySet());
               Collections.sort(var21);
               ArrayList var22 = new ArrayList();
               Iterator var23 = var21.iterator();

               while(var23.hasNext()) {
                  Integer var24 = (Integer)var23.next();
                  TXBillItemVO var25 = (TXBillItemVO)bodyMap.get(var24);
                  if(var25 != null) {
                     var22.add(var25);
                  }
               }

               if(CollectionUtils.isNotEmpty(var22)) {
                  aggTXBillVO.setChildrenVO((CircularlyAccessibleValueObject[])var22.toArray(new TXBillItemVO[0]));
               }
            }

            retcard = this.afterProcess(info.getPagecode(), vos[0]);
         }
      } catch (Exception var20) {
         ExceptionUtils.wrapException(var20);
      }

      return retcard;
   }

   private void processBillFormBillType(BillCard billCard) throws BusinessException {
      Form headForm = billCard.getHead();
      Row[] rows = headForm.getModel().getRows();

      for(int i = 0; i < rows.length; ++i) {
         Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
         Cell cell2 = rows[i].getCell("pk_srctradetypeid");
         String pk_currbilltype = null;
         if(cell2 != null && cell2.getValue() != null) {
            pk_currbilltype = String.valueOf(cell2.getValue());
         } else {
            pk_currbilltype = String.valueOf(cell1.getValue());
         }

         BilltypeVO billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
         if(billType != null && CloudFusionUtil.isCloudFusionProduct(billType.getSystemcode())) {
            Cell billtypeCell = new Cell();
            if(billType.istransaction != null && billType.istransaction.booleanValue()) {
               String parentTypeCode = billType.getParentbilltype();
               billType.getPk_billtypecode().setValue(parentTypeCode);
               if(StringUtils.isBlank(cell2.getDisplay())) {
                  cell2.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }

               if(StringUtils.isBlank(cell1.getDisplay())) {
                  BilltypeVO parentBillType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(parentTypeCode);
                  if(parentBillType != null) {
                     cell1.setDisplay(FipLangTool.getCurrLangValue(parentBillType, "billtypename"));
                  }
               }
            } else {
               billtypeCell.setValue(billType.getPk_billtypecode());
               if(StringUtils.isBlank(cell1.getDisplay())) {
                  cell1.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }
            }

            billtypeCell.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
            rows[i].addCell("pk_currbilltype", billtypeCell);
         }
      }

   }

   private BillCard afterProcess(String pageid, Object vo) throws BusinessException {
      BillCardOperator operator = new BillCardOperator(pageid);
      operator.setTransFlag(Boolean.TRUE.booleanValue());
      BillCard billCard = operator.toCard(vo);
      this.processBillFormBillType(billCard);
      return billCard;
   }
}
