package nccloud.web.fip.txmsgdata.action;

import nc.itf.fip.opreatinglog.GenerateRelatedBillService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class QueryBillsByDesInfoAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);
      Object[] vos = null;
      Grid grid = null;

      try {
         GenerateRelatedBillService e = (GenerateRelatedBillService)ServiceLocator.find(GenerateRelatedBillService.class);
         vos = e.queryBill(info.getFipLink(), "src");
         if(vos == null || vos.length == 0) {
            ExceptionUtils.wrapBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("2006pub_0", "02006pub-0795"));
         }

         if(vos != null) {
            TXBillVO[] parent = new TXBillVO[vos.length];

            for(int operator = 0; operator < vos.length; ++operator) {
               parent[operator] = ((AggTXBillVO)vos[operator]).getParentVO();
            }

            GridOperator var11 = new GridOperator(info.getPageId());
            grid = var11.toGrid(parent);
            this.processBillGridBillType(grid, parent);
         }
      } catch (Exception var10) {
         ExceptionUtils.wrapException(var10);
      }

      return grid;
   }

   private void processBillGridBillType(Grid grid, TXBillVO[] heads) {
      String pk_group = heads[0].getPk_group();
      Row[] rows = grid.getModel().getRows();

      for(int i = 0; i < rows.length; ++i) {
         Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
         Cell cell2 = rows[i].getCell("pk_srctradetypeid");
         String pk_currbilltype = null;
         if(cell2 != null && cell2.getValue() != null) {
            pk_currbilltype = String.valueOf(cell2.getValue());
         } else {
            pk_currbilltype = String.valueOf(cell1.getValue());
         }

         BilltypeVO billType = null;

         try {
            billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
         } catch (BusinessException var11) {
            ExceptionUtils.wrapException(var11);
         }

         if(billType != null) {
            Cell billtypeCell = new Cell();
            billtypeCell.setValue(billType.getPk_billtypecode());
            billtypeCell.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
            rows[i].addCell("pk_currbilltype", billtypeCell);
         }
      }

   }
}
