package nccloud.web.fip.txmsgdata.action;

import nc.itf.fip.opreatinglog.GenerateRelatedBillService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.form.Form;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class QueryBillByDesInfoAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);
      Object[] vos = null;
      BillCard retcard = null;

      try {
         GenerateRelatedBillService e = (GenerateRelatedBillService)ServiceLocator.find(GenerateRelatedBillService.class);
         vos = e.queryBill(info.getFipLink(), "src");
         if(vos == null || vos.length == 0) {
            ExceptionUtils.wrapBusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("2006pub_0", "02006pub-0795"));
         }

         if(vos != null && vos.length > 0) {
            retcard = this.afterProcess(info.getPageId(), vos[0]);
         }
      } catch (Exception var8) {
         ExceptionUtils.wrapException(var8);
      }

      return retcard;
   }

   private BillCard afterProcess(String pageid, Object vo) {
      BillCardOperator operator = new BillCardOperator(pageid);
      operator.setTransFlag(false);
      BillCard billCard = operator.toCard(vo);
      this.processBillFormBillType(billCard);
      return billCard;
   }

   private void processBillFormBillType(BillCard billCard) {
      Form headForm = billCard.getHead();
      Row[] rows = headForm.getModel().getRows();

      for(int i = 0; i < rows.length; ++i) {
         Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
         Cell cell2 = rows[i].getCell("pk_srctradetypeid");
         Cell cell3 = rows[i].getCell("pk_system");
         String pk_currbilltype;
         if(cell3 != null && cell3.getValue() != null) {
            pk_currbilltype = String.valueOf(cell3.getValue());
            if("EM".equals(pk_currbilltype)) {
               cell3.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
               cell3.setValue(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
            }

            if("YXY".equals(pk_currbilltype)) {
               cell3.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
               cell3.setValue(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
            }
         }

         pk_currbilltype = null;
         if(cell2 != null && cell2.getValue() != null) {
            pk_currbilltype = String.valueOf(cell2.getValue());
         } else {
            pk_currbilltype = String.valueOf(cell1.getValue());
         }

         BilltypeVO billType = null;

         try {
            billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
         } catch (BusinessException var12) {
            ExceptionUtils.wrapException(var12);
         }

         if(billType != null) {
            Cell billtypeCell = new Cell();
            if(billType.istransaction != null && billType.istransaction.booleanValue()) {
               String parentBillType = billType.getParentbilltype();
               billType.getPk_billtypecode().setValue(parentBillType);
               if(StringUtils.isBlank(cell2.getDisplay())) {
                  cell2.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }
            } else {
               billtypeCell.setValue(billType.getPk_billtypecode());
               if(StringUtils.isBlank(cell1.getDisplay())) {
                  cell1.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }
            }

            billtypeCell.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
            rows[i].addCell("pk_currbilltype", billtypeCell);
         }
      }

   }
}
