package nccloud.web.fip.txmsgdata.action;

import nc.itf.fip.ITXMessageDataService;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.pub.CloudFusionUtil;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.txbill.AggTXBillVO;
import nc.vo.fip.txbill.TXBillVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pubapp.pattern.model.entity.bill.IBill;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.platform.query.INCCloudQueryService;
import nccloud.web.fip.txmsgdata.action.PageQueryVO;
import nccloud.web.fip.txmsgdata.action.SearchInfo;
import nccloud.web.fip.util.PageUtil;

public class QueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Grid grid = null;
      String str = request.read();
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(str, SearchInfo.class);

      try {
         INCCloudQueryService e = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
         IQueryScheme scheme = e.convertCondition(info.getQueryInfo());
         AggTXBillVO[] vos = ((ITXMessageDataService)ServiceLocator.find(ITXMessageDataService.class)).query(scheme);
         if(vos == null || vos.length == 0) {
            return null;
         }

         String[] pks = new String[vos.length];

         for(int qvo = 0; qvo < vos.length; ++qvo) {
            TXBillVO pageInfo = vos[qvo].getParentVO();
            pks[qvo] = pageInfo.getPk_txbill();
         }

         PageQueryVO var13 = new PageQueryVO(pks, vos);
         grid = this.convert(var13, info);
         PageInfo var14 = new PageInfo();
         var14.setTotal(pks.length);
         var14.setPageSize(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue());
         var14.setPageIndex(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageIndex()).intValue());
         var14.setTotalPage(PageUtil.getTotalPage(var14, pks.length));
         grid.getModel().setPageinfo(var14);
      } catch (Exception var12) {
         ExceptionUtils.wrapException(var12);
      }

      return grid;
   }

   private Grid convert(PageQueryVO result, SearchInfo info) throws BusinessException {
      IBill[] bills = result.getCurrentPageBills();
      int copySize = bills.length < Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue()?bills.length:Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue();
      Grid grid = null;
      if(bills != null) {
         TXBillVO[] heads = new TXBillVO[copySize];

         for(int operator = 0; operator < copySize; ++operator) {
            heads[operator] = (TXBillVO)bills[operator].getParent();
         }

         GridOperator var8 = new GridOperator(info.getPagecode());
         grid = var8.toGrid(heads);
         this.processBillGridBillType(grid, heads);
         grid.getModel().setAllpks(result.getPks());
      }

      return grid;
   }

   private void processBillGridBillType(Grid grid, TXBillVO[] heads) throws BusinessException {
      Row[] rows = grid.getModel().getRows();

      for(int i = 0; i < rows.length; ++i) {
         Cell cell1 = rows[i].getCell("pk_srcbilltypeid");
         Cell cell2 = rows[i].getCell("pk_srctradetypeid");
         String pk_currbilltype = null;
         if(cell2 != null && cell2.getValue() != null) {
            pk_currbilltype = String.valueOf(cell2.getValue());
         } else {
            pk_currbilltype = String.valueOf(cell1.getValue());
         }

         BilltypeVO billType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(pk_currbilltype);
         Cell pkSystemCell;
         if(billType != null && CloudFusionUtil.isCloudFusionProduct(billType.getSystemcode())) {
            pkSystemCell = new Cell();
            if(billType.istransaction != null && billType.istransaction.booleanValue()) {
               String parentTypeCode = billType.getParentbilltype();
               billType.getPk_billtypecode().setValue(parentTypeCode);
               if(StringUtils.isBlank(cell2.getDisplay())) {
                  cell2.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }

               if(StringUtils.isBlank(cell1.getDisplay())) {
                  BilltypeVO parentBillType = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).getBilltypeByPk(parentTypeCode);
                  if(parentBillType != null) {
                     cell1.setDisplay(FipLangTool.getCurrLangValue(parentBillType, "billtypename"));
                  }
               }
            } else {
               pkSystemCell.setValue(billType.getPk_billtypecode());
               if(StringUtils.isBlank(cell1.getDisplay())) {
                  cell1.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
               }
            }

            pkSystemCell.setDisplay(FipLangTool.getCurrLangValue(billType, "billtypename"));
            rows[i].addCell("pk_currbilltype", pkSystemCell);
         }

         pkSystemCell = rows[i].getCell("pk_system");
         if(pkSystemCell.getValue() != null && "EM".equals(pkSystemCell.getValue())) {
            pkSystemCell.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0909"));
         }

         if(pkSystemCell.getValue() != null && "YXY".equals(pkSystemCell.getValue())) {
            pkSystemCell.setDisplay(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0912"));
         }

         rows[i].addCell("pk_system", pkSystemCell);
      }

   }
}
