package nccloud.web.fip.txmsgdata.action;

import java.util.HashMap;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.pubitf.fip.service.IFipBillQueryService;
import nc.vo.fip.service.FipRelationInfoVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class BillLinkVoucharQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      FipRelationInfoVO[] vos = (FipRelationInfoVO[])json.fromJson(str, FipRelationInfoVO[].class);
      Object map = new HashMap();

      try {
         if(!ArrayUtils.isNotEmpty(vos)) {
            return null;
         }

         HashMap e = new HashMap();
         FipRelationInfoVO[] var7 = vos;
         int var8 = vos.length;

         for(int var9 = 0; var9 < var8; ++var9) {
            FipRelationInfoVO fipRelationInfoVO = var7[var9];
            String pk_billtype = fipRelationInfoVO.getPk_billtype();
            String billtypeCode = (String)e.get(pk_billtype);
            if(StringUtils.isNotEmpty(billtypeCode)) {
               fipRelationInfoVO.setPk_billtype(billtypeCode);
            } else {
               BilltypeVO billtypeVO = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).queryByPk(pk_billtype);
               if(billtypeVO != null) {
                  fipRelationInfoVO.setPk_billtype(billtypeVO.getPk_billtypecode());
                  e.put(pk_billtype, billtypeVO.getPk_billtypecode());
               }
            }
         }

         map = ((IFipBillQueryService)ServiceLocator.find(IFipBillQueryService.class)).queryDesAppInfoBySrc(vos);
      } catch (BusinessException var14) {
         ExceptionUtils.wrapBusinessException(var14.getMessage());
      }

      return map;
   }
}
