package nccloud.web.fip.transtemplate.tool;

import java.util.HashMap;
import java.util.Map;
import nc.itf.gl.fip.IVoucherSumRuleQryService;
import nc.vo.bd.pub.BDCacheQueryUtil;
import nc.vo.fip.transtemplate.TemplateRowVO;
import nc.vo.fip.transtemplate.TransTemplateVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.org.OrgVO;
import nc.vo.org.SetOfBookVO;
import nc.vo.pub.BusinessException;
import nc.vo.voucher.fip.Aggcombinscheme;
import nc.vo.voucher.fip.CombinschemeVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.billcard.SpecilAggBill;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class TranstemplateDispTool {

   public static Map TranstemplateConvert(String pageId, TransTemplateVO templateVO) {
      try {
         String e = SessionContext.getInstance().getClientInfo().getPk_group();
         String pk_org = templateVO.getPk_org();
         String src_billtype = templateVO.getSrc_billtype();
         String des_billtype = templateVO.getDes_billtype();
         BillCard retcard = convertTemplateHead(pageId, templateVO, e, pk_org, src_billtype, des_billtype);
         HashMap map = new HashMap();
         Map heads = retcard.getHead().getModel().getRows()[0].getValues();
         map.put("head", heads);
         TemplateRowVO[] bodyRows = templateVO.getRowvalues();
         if(bodyRows != null && bodyRows.length > 0) {
            ITransTemplateService translateService = (ITransTemplateService)ServiceLocator.find(ITransTemplateService.class);
            TemplateRowVO[] bodyRowsConvert = translateService.convertTemplateBodyData(bodyRows, e, pk_org, src_billtype, des_billtype, templateVO.getDes_factor1());
            map.put("body", bodyRowsConvert);
         }

         return map;
      } catch (BusinessException var12) {
         ExceptionUtils.wrapBusinessException(var12.getMessage());
         return null;
      }
   }

   public static BillCard convertTemplateHead(String pageId, TransTemplateVO templateVO, String pk_group, String pk_org, String src_billtype, String des_billtype) throws BusinessException {
      SpecilAggBill specialBill = new SpecilAggBill();
      TransTemplateVO cloneTemplate = (TransTemplateVO)templateVO.clone();
      cloneTemplate.setRowvalues((TemplateRowVO[])null);
      specialBill.setHead(cloneTemplate);
      BillCardOperator operator = new BillCardOperator(pageId);
      BillCard retcard = operator.toCard(specialBill);
      Row[] headRows = retcard.getHead().getModel().getRows();
      if(headRows != null) {
         HashMap valueMap = new HashMap();
         valueMap.put("expmessage1", templateVO.getExpmessage1());
         valueMap.put("expmessage2", templateVO.getExpmessage2());
         valueMap.put("expmessage3", templateVO.getExpmessage3());
         valueMap.put("expmessage4", templateVO.getExpmessage4());
         valueMap.put("expmessage5", templateVO.getExpmessage5());
         valueMap.put("expmessage6", templateVO.getExpmessage6());
         valueMap.put("expmessage7", templateVO.getExpmessage7());
         valueMap.put("expmessage8", templateVO.getExpmessage8());
         valueMap.put("expmessage9", templateVO.getExpmessage9());
         valueMap.put("expmessage10", templateVO.getExpmessage10());
         ITransTemplateService translateService = (ITransTemplateService)ServiceLocator.find(ITransTemplateService.class);
         Map displayShowMap = translateService.convertTemplateHeadData(valueMap, pk_group, pk_org, src_billtype, des_billtype, templateVO.getDes_factor1());
         if(templateVO.getPk_org() == null) {
            templateVO.setPk_org("GLOBLE00000000000000");
         }

         SetOfBookVO[] setofbookVOs = (SetOfBookVO[])BDCacheQueryUtil.queryVOsByIDs(SetOfBookVO.class, "pk_setofbook", new String[]{templateVO.getPk_org()}, (String[])null);
         OrgVO[] orgVOs = (OrgVO[])BDCacheQueryUtil.queryVOsByIDs(OrgVO.class, "pk_org", new String[]{templateVO.getPk_org()}, (String[])null);
         Object currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
         Row[] var17 = headRows;
         int var18 = headRows.length;

         for(int var19 = 0; var19 < var18; ++var19) {
            Row row = var17[var19];
            Cell name = row.getCell("name");
            Cell nameLang = row.getCell((String)currLangIndex);
            if(nameLang != null && nameLang.getValue() != null) {
               name = nameLang;
            }

            row.addCell("name", name);
            Cell expmessage1 = row.getCell("expmessage1");
            if(expmessage1 != null && expmessage1.getValue() != null) {
               expmessage1.setDisplay((String)displayShowMap.get("expmessage1"));
            }

            Cell expmessage2 = row.getCell("expmessage2");
            if(expmessage2 != null && expmessage2.getValue() != null) {
               expmessage2.setDisplay((String)displayShowMap.get("expmessage2"));
            }

            Cell expmessage3 = row.getCell("expmessage3");
            if(expmessage3 != null && expmessage3.getValue() != null) {
               expmessage3.setDisplay((String)displayShowMap.get("expmessage3"));
            }

            Cell expmessage4 = row.getCell("expmessage4");
            if(expmessage4 != null && expmessage4.getValue() != null) {
               expmessage4.setDisplay((String)displayShowMap.get("expmessage4"));
            }

            Cell expmessage5 = row.getCell("expmessage5");
            if(expmessage5 != null && expmessage5.getValue() != null) {
               expmessage5.setDisplay((String)displayShowMap.get("expmessage5"));
            }

            Cell expmessage6 = row.getCell("expmessage6");
            if(expmessage6 != null && expmessage6.getValue() != null) {
               expmessage6.setDisplay((String)displayShowMap.get("expmessage6"));
            }

            Cell expmessage7 = row.getCell("expmessage7");
            if(expmessage7 != null && expmessage7.getValue() != null) {
               expmessage7.setDisplay((String)displayShowMap.get("expmessage7"));
            }

            Cell expmessage8 = row.getCell("expmessage8");
            if(expmessage8 != null && expmessage8.getValue() != null) {
               expmessage8.setDisplay((String)displayShowMap.get("expmessage8"));
            }

            Cell expmessage9 = row.getCell("expmessage9");
            if(expmessage9 != null && expmessage9.getValue() != null) {
               expmessage9.setDisplay((String)displayShowMap.get("expmessage9"));
            }

            Cell expmessage10 = row.getCell("expmessage10");
            if(expmessage10 != null && expmessage10.getValue() != null) {
               expmessage10.setDisplay((String)displayShowMap.get("expmessage10"));
            }

            Cell pk_org00 = row.getCell("pk_org");
            if(pk_org00 != null) {
               String pk_sumrule;
               String scheme;
               if(setofbookVOs != null && setofbookVOs.length > 0 && setofbookVOs[0] != null) {
                  pk_sumrule = setofbookVOs[0].getName();
                  scheme = (String)setofbookVOs[0].getAttributeValue((String)currLangIndex);
                  if(currLangIndex != true && StringUtils.isNotBlank(scheme)) {
                     pk_sumrule = scheme;
                  }

                  pk_org00.setDisplay(pk_sumrule);
               } else if(orgVOs != null && orgVOs.length > 0 && orgVOs[0] != null) {
                  pk_sumrule = orgVOs[0].getName();
                  scheme = (String)orgVOs[0].getAttributeValue((String)currLangIndex);
                  if(currLangIndex != true && StringUtils.isNotBlank(scheme)) {
                     pk_sumrule = scheme;
                  }

                  pk_org00.setDisplay(pk_sumrule);
               }
            }

            Cell var40 = row.getCell("pk_sumrule");
            Aggcombinscheme var39;
            if(var40 != null && var40.getValue() != null && var40.getValue().toString().length() > 0) {
               var39 = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)var40.getValue());
               if(var39 != null && var39.getParentVO() != null) {
                  CombinschemeVO gl_sumrule = (CombinschemeVO)var39.getParentVO();
                  var40.setDisplay(StringUtils.isNotEmpty(gl_sumrule.getName())?gl_sumrule.getName():gl_sumrule.getCode());
               }
            }

            Cell var41 = row.getCell("pk_glsumrule");
            if(var41 != null && var41.getValue() != null && var41.getValue().toString().length() > 0) {
               var39 = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)var41.getValue());
               if(var39 != null && var39.getParentVO() != null) {
                  CombinschemeVO ra_sumrule = (CombinschemeVO)var39.getParentVO();
                  var41.setDisplay(StringUtils.isNotEmpty(ra_sumrule.getName())?ra_sumrule.getName():ra_sumrule.getCode());
               }
            }

            Cell var42 = row.getCell("pk_rasumrule");
            if(var42 != null && var42.getValue() != null && var42.getValue().toString().length() > 0) {
               var39 = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)var42.getValue());
               if(var39 != null && var39.getParentVO() != null) {
                  CombinschemeVO schemeVO = (CombinschemeVO)var39.getParentVO();
                  var42.setDisplay(StringUtils.isNotEmpty(schemeVO.getName())?schemeVO.getName():schemeVO.getCode());
               }
            }
         }
      }

      return retcard;
   }
}
