package nccloud.web.fip.transtemplate.adapter;

import java.util.ArrayList;
import nc.bs.framework.common.InvocationInfoProxy;
import nc.itf.fip.transtemplate.FipTemplateUtil;
import nc.vo.fip.transtemplate.TemplateCellVO;
import nc.vo.fip.transtemplate.TemplateRowVO;
import nc.vo.fip.transtemplate.TransTemplateVO;
import nc.vo.pub.lang.UFBoolean;
import nc.vo.pub.lang.UFDateTime;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.fip.transtemplate.TransTemplateWebHVO;
import nccloud.dto.fip.transtemplate.TransTemplateWebRowVO;
import nccloud.dto.fip.transtemplate.TransTemplateWebVO;
import nccloud.dto.fip.transtemplate.ValueObject;
import nccloud.framework.web.container.SessionContext;

public class TransTemplateAdapter {

   public static TransTemplateVO trans2TemplateVO(TransTemplateWebVO webVO) {
      TransTemplateVO transTemplateVO = new TransTemplateVO();
      TransTemplateWebHVO head = webVO.getHead();
      if(!isEmptyWithTrim(head.getPk_transtemplate())) {
         transTemplateVO.setPk_transtemplate((String)head.getPk_transtemplate().getValue());
      }

      if(!isEmptyWithTrim(head.getPk_group())) {
         transTemplateVO.setPk_group((String)head.getPk_group().getValue());
      } else {
         transTemplateVO.setPk_group(SessionContext.getInstance().getClientInfo().getPk_group());
      }

      if(!isEmptyWithTrim(head.getPk_org())) {
         transTemplateVO.setPk_org((String)head.getPk_org().getValue());
      }

      if(!isEmptyWithTrim(head.getSrc_billtype())) {
         transTemplateVO.setSrc_billtype((String)head.getSrc_billtype().getValue());
      }

      if(!isEmptyWithTrim(head.getDes_billtype())) {
         transTemplateVO.setDes_billtype((String)head.getDes_billtype().getValue());
      }

      if(!isEmptyWithTrim(head.getGeneratemode())) {
         transTemplateVO.setGeneratemode(Integer.valueOf(head.getGeneratemode().getValue().toString()));
      }

      if(!isEmptyWithTrim(head.getEffectflag())) {
         transTemplateVO.setEffectflag(((Boolean)head.getEffectflag().getValue()).booleanValue()?UFBoolean.valueOf(true):UFBoolean.valueOf(false));
      } else {
         transTemplateVO.setEffectflag(UFBoolean.valueOf(false));
      }

      if(!isEmptyWithTrim(head.getDes_factor1())) {
         transTemplateVO.setDes_factor1((String)head.getDes_factor1().getValue());
      }

      if(!isEmptyWithTrim(head.getFactor1())) {
         transTemplateVO.setFactor1((String)head.getFactor1().getValue());
      }

      if(!isEmptyWithTrim(head.getFactor2())) {
         transTemplateVO.setFactor2((String)head.getFactor2().getValue());
      }

      if(!isEmptyWithTrim(head.getFactor3())) {
         transTemplateVO.setFactor3((String)head.getFactor3().getValue());
      }

      if(!isEmptyWithTrim(head.getPk_docconvert()) && StringUtils.isNoneBlank(new CharSequence[]{(String)head.getPk_docconvert().getValue()})) {
         transTemplateVO.setPk_docconvert((String)head.getPk_docconvert().getValue());
      }

      if(!isEmptyWithTrim(head.getPk_sumrule())) {
         transTemplateVO.setPk_sumrule((String)head.getPk_sumrule().getValue());
      }

      if(!isEmptyWithTrim(head.getIsleachbody())) {
         transTemplateVO.setIsleachbody(((Boolean)head.getIsleachbody().getValue()).booleanValue()?UFBoolean.valueOf(true):UFBoolean.valueOf(false));
      } else {
         transTemplateVO.setIsleachbody(UFBoolean.valueOf(false));
      }

      if(!isEmptyWithTrim(head.getExpmessage1())) {
         transTemplateVO.setExpmessage1((String)head.getExpmessage1().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage2())) {
         transTemplateVO.setExpmessage2((String)head.getExpmessage2().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage3())) {
         transTemplateVO.setExpmessage3((String)head.getExpmessage3().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage4())) {
         transTemplateVO.setExpmessage4((String)head.getExpmessage4().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage5())) {
         transTemplateVO.setExpmessage5((String)head.getExpmessage5().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage6())) {
         transTemplateVO.setExpmessage6((String)head.getExpmessage6().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage7())) {
         transTemplateVO.setExpmessage7((String)head.getExpmessage7().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage8())) {
         transTemplateVO.setExpmessage8((String)head.getExpmessage8().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage9())) {
         transTemplateVO.setExpmessage9((String)head.getExpmessage9().getValue());
      }

      if(!isEmptyWithTrim(head.getExpmessage10())) {
         transTemplateVO.setExpmessage10((String)head.getExpmessage10().getValue());
      }

      if(!isEmptyWithTrim(head.getDesbillmode())) {
         transTemplateVO.setDesbillmode(Integer.valueOf(head.getDesbillmode().getValue().toString()));
      }

      String pk_transtemplate = transTemplateVO.getPk_transtemplate();
      String userid = InvocationInfoProxy.getInstance().getUserId();
      if(!isEmptyWithTrim(head.getCreator())) {
         transTemplateVO.setCreator((String)head.getCreator().getValue());
      } else if(pk_transtemplate == null) {
         transTemplateVO.setCreator(userid);
      }

      if(!isEmptyWithTrim(head.getCreationtime())) {
         transTemplateVO.setCreationtime(new UFDateTime((String)head.getCreationtime().getValue()));
      } else if(pk_transtemplate == null) {
         transTemplateVO.setCreationtime(new UFDateTime());
      }

      if(pk_transtemplate != null) {
         transTemplateVO.setModifier(userid);
         transTemplateVO.setModifiedtime(new UFDateTime());
      }

      if(!isEmptyWithTrim(head.getDef1())) {
         transTemplateVO.setDef1((String)head.getDef1().getValue());
      }

      if(!isEmptyWithTrim(head.getDef2())) {
         transTemplateVO.setDef2((String)head.getDef2().getValue());
      }

      if(!isEmptyWithTrim(head.getDef3())) {
         transTemplateVO.setDef3((String)head.getDef3().getValue());
      }

      if(!isEmptyWithTrim(head.getDef4())) {
         transTemplateVO.setDef4((String)head.getDef4().getValue());
      }

      if(!isEmptyWithTrim(head.getDef5())) {
         transTemplateVO.setDef5((String)head.getDef5().getValue());
      }

      if(!isEmptyWithTrim(head.getDef6())) {
         transTemplateVO.setDef6((String)head.getDef6().getValue());
      }

      if(!isEmptyWithTrim(head.getDef7())) {
         transTemplateVO.setDef7((String)head.getDef7().getValue());
      }

      if(!isEmptyWithTrim(head.getDef8())) {
         transTemplateVO.setDef8((String)head.getDef8().getValue());
      }

      if(!isEmptyWithTrim(head.getDef9())) {
         transTemplateVO.setDef9((String)head.getDef9().getValue());
      }

      if(!isEmptyWithTrim(head.getDef10())) {
         transTemplateVO.setDef10((String)head.getDef10().getValue());
      }

      if(!isEmptyWithTrim(head.getDr())) {
         transTemplateVO.setDr(Integer.valueOf(head.getDr().getValue().toString()));
      }

      if(!isEmptyWithTrim(head.getTs())) {
         transTemplateVO.setTs(new UFDateTime((String)head.getTs().getValue()));
      }

      if(!isEmptyWithTrim(head.getCode())) {
         transTemplateVO.setCode((String)head.getCode().getValue());
      }

      if(!isEmptyWithTrim(head.getName())) {
         transTemplateVO.setName((String)head.getName().getValue());
      }

      if(!isEmptyWithTrim(head.getName2())) {
         transTemplateVO.setName2((String)head.getName2().getValue());
      }

      if(!isEmptyWithTrim(head.getName3())) {
         transTemplateVO.setName3((String)head.getName3().getValue());
      }

      if(!isEmptyWithTrim(head.getName4())) {
         transTemplateVO.setName4((String)head.getName4().getValue());
      }

      if(!isEmptyWithTrim(head.getName5())) {
         transTemplateVO.setName5((String)head.getName5().getValue());
      }

      if(!isEmptyWithTrim(head.getName6())) {
         transTemplateVO.setName6((String)head.getName6().getValue());
      }

      if(!isEmptyWithTrim(head.getDescription())) {
         transTemplateVO.setDescription((String)head.getDescription().getValue());
      }

      if(!isEmptyWithTrim(head.getIsdefault())) {
         transTemplateVO.setIsdefault(((Boolean)head.getIsdefault().getValue()).booleanValue()?UFBoolean.valueOf(true):UFBoolean.valueOf(false));
      } else {
         transTemplateVO.setIsdefault(UFBoolean.valueOf(false));
      }

      if(!isEmptyWithTrim(head.getPk_glsumrule())) {
         transTemplateVO.setPk_glsumrule((String)head.getPk_glsumrule().getValue());
      }

      if(!isEmptyWithTrim(head.getPk_rasumrule())) {
         transTemplateVO.setPk_rasumrule((String)head.getPk_rasumrule().getValue());
      }

      if(!isEmptyWithTrim(head.getIsinit()) && Boolean.parseBoolean(head.getIsinit().getValue().toString()) && "GLOBLE00000000000000".equals(transTemplateVO.getPk_group()) && !FipTemplateUtil.isEnableModifyPresetTemplateParam().booleanValue()) {
         transTemplateVO.setIsinit(UFBoolean.valueOf(true));
      } else {
         transTemplateVO.setIsinit(UFBoolean.valueOf(false));
      }

      if(!isEmptyWithTrim(head.getPk_transtemplate_resource())) {
         transTemplateVO.setPk_transtemplate_resource((String)head.getPk_transtemplate_resource().getValue());
      }

      transTemplateVO.setRowvalues(Convert2TemplateRow(webVO.getBody()));
      return transTemplateVO;
   }

   private static boolean isEmptyWithTrim(ValueObject obj) {
      return obj == null || obj.getValue() == null;
   }

   private static TemplateRowVO[] Convert2TemplateRow(TransTemplateWebRowVO[] bodyRows) {
      ArrayList rowList = new ArrayList();
      if(bodyRows != null && bodyRows.length > 0) {
         TransTemplateWebRowVO[] var2 = bodyRows;
         int var3 = bodyRows.length;

         for(int var4 = 0; var4 < var3; ++var4) {
            TransTemplateWebRowVO row = var2[var4];
            TemplateRowVO newRowVO = new TemplateRowVO();
            newRowVO.setPk_transtemplate(row.getPk_transtemplate());
            newRowVO.setPk_templaterow(row.getPk_templaterow());
            newRowVO.setFk_templaterow(row.getFk_templaterow());
            newRowVO.setDesentity(row.getDesentity());
            newRowVO.setRowindex(row.getRowindex());
            TemplateCellVO[] cells = row.getCellvalues();
            newRowVO.setCellvalues(cells);
            newRowVO.setBodies((TemplateRowVO[])null);
            TransTemplateWebRowVO[] rows = row.getBodies();
            if(rows != null && rows.length > 0) {
               newRowVO.setBodies(Convert2TemplateRow(row.getBodies()));
            }

            newRowVO.setDr(row.getDr());
            newRowVO.setTs(row.getTs());
            rowList.add(newRowVO);
         }
      }

      return rowList.size() == 0?null:(TemplateRowVO[])rowList.toArray(new TemplateRowVO[0]);
   }
}
