package nccloud.web.fip.transtemplate.action;

import nc.itf.fip.transtemplate.FipTemplateUtil;
import nc.itf.fip.transtemplate.IFipTransTemplate;
import nc.vo.fip.transtemplate.TransTemplateVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.fip.transtemplate.TransTemplateWebVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.transtemplate.adapter.TransTemplateAdapter;
import nccloud.web.fip.transtemplate.tool.TranstemplateDispTool;

public class TranstemplateSaveAction implements ICommonAction {

   public static final String PAGEID_TRANSTEMPLATEHEAD = "10170407_1017040701";


   public Object doAction(IRequest request) {
      try {
         String ex = request.read();
         TransTemplateWebVO templateWebVO = (TransTemplateWebVO)JsonFactory.create().fromJson(ex, TransTemplateWebVO.class);
         TransTemplateVO templateConvertVO = TransTemplateAdapter.trans2TemplateVO(templateWebVO);
         String pk_transtemplate = templateConvertVO.getPk_transtemplate();
         IFipTransTemplate fipTransService = (IFipTransTemplate)ServiceLocator.find(IFipTransTemplate.class);
         if("GLOBLE00000000000000".equals(templateConvertVO.getPk_group())) {
            fipTransService.checkCode(templateConvertVO);
         }

         if(FipTemplateUtil.isEnableModifyPresetTemplateParam().booleanValue()) {
            templateConvertVO.setIsinit(UFBoolean.TRUE);
         } else {
            templateConvertVO.setIsinit(UFBoolean.FALSE);
         }

         TransTemplateVO[] templates = null;
         if(StringUtils.isBlank(templateConvertVO.getFactor1())) {
            templateConvertVO.setFactor1((String)null);
         }

         if(pk_transtemplate == null) {
            templates = fipTransService.insert(new TransTemplateVO[]{templateConvertVO});
         } else {
            templates = fipTransService.update(new TransTemplateVO[]{templateConvertVO});
         }

         if(templates != null && templates.length > 0) {
            TransTemplateVO transTemplateVO = templates[0];
            if("GLOBLE00000000000000".equals(transTemplateVO.getPk_group()) && !FipTemplateUtil.isEnableModifyPresetTemplateParam().booleanValue()) {
               fipTransService.dealTransTemplateInitValue(transTemplateVO);
            }

            return TranstemplateDispTool.TranstemplateConvert("10170407_1017040701", transTemplateVO);
         }
      } catch (BusinessException var9) {
         ExceptionUtils.wrapException(var9);
      }

      return null;
   }
}
