package nccloud.web.fip.transtemplate.action;

import java.util.Map;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateQryService;

public class TranstemplateQryFactorAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      Map paraMap = (Map)JsonFactory.create().fromJson(json, Map.class);

      try {
         String ex = (String)paraMap.get("src_billtype");
         String des_billtype = (String)paraMap.get("des_billtype");
         if(ex != null && des_billtype != null) {
            String orgpk = (String)paraMap.get("des_org");
            return ((ITransTemplateQryService)ServiceLocator.find(ITransTemplateQryService.class)).queryTemplateFactorInfo(ex, des_billtype, orgpk);
         } else {
            return null;
         }
      } catch (BusinessException var7) {
         ExceptionUtils.wrapException(var7);
         return null;
      }
   }
}
