package nccloud.web.fip.transtemplate.action;

import java.io.IOException;
import java.io.InputStream;
import nc.bs.logging.Logger;
import nccloud.framework.core.io.WebFile;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.pubitf.fip.transtemplate.ITranstemplateImportService;

public class TranstemplateImportAction implements ICommonAction {

   public Object doAction(IRequest request) {
      WebFile[] webFile = request.readFiles();
      String fileName = webFile[0].getFileName();
      InputStream inputStream = webFile[0].getInputStream();

      String message;
      try {
         ITranstemplateImportService e = (ITranstemplateImportService)ServiceLocator.find(ITranstemplateImportService.class);
         message = e.doImport(fileName, inputStream);
      } catch (Exception var15) {
         message = var15.getMessage();
         if(message == null) {
            message = "导入出错，请查看后台日志！";
         }

         Logger.error("TranstemplateImportAction error->", var15);
      } finally {
         if(inputStream != null) {
            try {
               inputStream.close();
            } catch (IOException var14) {
               Logger.error(var14.getMessage(), var14);
            }
         }

      }

      return message;
   }
}
