package nccloud.web.fip.transtemplate.action;

import nc.vo.fip.transtemplate.TemplateExportTaskVO;
import nc.vo.fip.transtemplate.tool.TemplateExportRequest;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateExportTaskService;

public class TranstemplateExportProcessAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      boolean flag = false;

      try {
         TemplateExportRequest ex = (TemplateExportRequest)JsonFactory.create().fromJson(json, TemplateExportRequest.class);
         ITransTemplateExportTaskService ip = (ITransTemplateExportTaskService)ServiceLocator.find(ITransTemplateExportTaskService.class);
         TemplateExportTaskVO vo = ip.findTemplateExportTaskByID(ex.getTaskId());
         if(vo != null) {
            flag = vo.getIsfinish().booleanValue();
            if(flag) {
               ip.delete(ex.getTaskId());
            }
         }
      } catch (Exception var7) {
         ExceptionUtils.wrapException(var7);
      }

      return Boolean.valueOf(flag);
   }
}
