package nccloud.web.fip.transtemplate.action;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import nc.vo.fip.transtemplate.tool.TemplateExportRequest;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.io.WebFile;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.pubitf.fip.transtemplate.ITranstemplateExportService;

public class TranstemplateExportAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map mapstr = request.readParameters();
      String[] templateLevel = (String[])mapstr.get("templateLevel");
      String[] srcbilltype = (String[])mapstr.get("srcbilltype");
      String[] desbilltype = (String[])mapstr.get("desbilltype");
      String[] setofbook = (String[])mapstr.get("setofbook");
      String[] accbook = (String[])mapstr.get("accbook");
      String[] taskId = (String[])mapstr.get("taskId");
      String[] desaccbooks = (String[])mapstr.get("desaccbook");
      WebFile webFile = null;

      try {
         TemplateExportRequest ex = new TemplateExportRequest();
         ex.setTaskId(taskId[0]);
         if(ArrayUtils.isNotEmpty(templateLevel)) {
            ex.setTemplateLevel(templateLevel[0]);
         }

         if(ArrayUtils.isNotEmpty(srcbilltype)) {
            ex.setSrcbilltype(srcbilltype[0]);
         }

         if(ArrayUtils.isNotEmpty(desbilltype)) {
            ex.setDesbilltype(desbilltype[0]);
         }

         if(ArrayUtils.isNotEmpty(setofbook)) {
            ex.setSetofbook(setofbook[0]);
         }

         if(ArrayUtils.isNotEmpty(accbook)) {
            ex.setAccbook(accbook[0]);
         }

         if(ArrayUtils.isNotEmpty(desaccbooks)) {
            ex.setDesaccbook(desaccbooks[0]);
         }

         ITranstemplateExportService service = (ITranstemplateExportService)ServiceLocator.find(ITranstemplateExportService.class);
         String path = service.exportData(ex);
         File file = new File(path);
         file.setExecutable(false);
         file.setReadable(true);
         file.setWritable(true);
         webFile = new WebFile("export.zip", file.length(), new FileInputStream(file));
      } catch (Exception var15) {
         ExceptionUtils.wrapException(var15);
      }

      return webFile;
   }
}
