package nccloud.web.fip.transtemplate.action;

import java.util.Map;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateBillItemQryService;

public class TranstemplateDestBillItemQryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      Map paraMap = (Map)JsonFactory.create().fromJson(json, Map.class);
      String pk_billtype = (String)paraMap.get("pk_billtype");
      if(pk_billtype == null) {
         return null;
      } else {
         try {
            Map ex = ((ITransTemplateBillItemQryService)ServiceLocator.find(ITransTemplateBillItemQryService.class)).rebuildUIByBilltype(pk_billtype);
            return ex;
         } catch (BusinessException var6) {
            ExceptionUtils.wrapException(var6);
            return null;
         }
      }
   }
}
