package nccloud.web.fip.transtemplate.action;

import com.google.gson.JsonObject;
import nc.vo.fip.templateassign.TemplateassignVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateAssignService;

public class TemplateQueryAssignmentAction implements ICommonAction {

   public Object doAction(IRequest request) {
      int count = 0;

      try {
         String ex = request.read();
         JsonObject jb = (JsonObject)JsonFactory.create().fromJson(ex, JsonObject.class);
         String pk = jb.get("value").getAsString();
         if(StringUtils.isNotEmpty(pk)) {
            ITransTemplateAssignService service = (ITransTemplateAssignService)ServiceLocator.find(ITransTemplateAssignService.class);
            TemplateassignVO[] vos = service.queryTemplateAssignList(pk);
            if(vos != null) {
               count = vos.length;
            }
         }
      } catch (BusinessException var9) {
         ExceptionUtils.wrapException(var9);
      }

      return Integer.valueOf(count);
   }
}
