package nccloud.web.fip.transtemplate.action;

import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateCopyService;

public class TemplateDiscernRefInfoAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(str, QueryTemplateInfo4Web.class);
      String pkOrg = ((Conditions)info.getConditions().get(0)).getValue().getFirstvalue();
      String des_org = ((Conditions)info.getConditions().get(1)).getValue().getFirstvalue();
      String pk_org = ((Conditions)info.getConditions().get(2)).getValue().getFirstvalue();
      String node_type = ((Conditions)info.getConditions().get(3)).getValue().getFirstvalue();
      boolean flag = false;

      try {
         flag = ((ITransTemplateCopyService)ServiceLocator.find(ITransTemplateCopyService.class)).discernRefInfo(pkOrg, des_org, pk_org, node_type);
      } catch (BusinessException var11) {
         ExceptionUtils.wrapException(var11);
      }

      return Boolean.valueOf(flag);
   }
}
