package nccloud.web.fip.transtemplate.action;

import com.google.gson.JsonObject;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateCopyService;

public class TemplateCopyGlobalDataAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         JsonObject jb = (JsonObject)JsonFactory.create().fromJson(e, JsonObject.class);
         String sys_pk = jb.get("sys_pk").getAsString();
         String pk_group = jb.get("pk_group").getAsString();
         String pk_org = jb.get("pk_org") == null?null:jb.get("pk_org").getAsString();
         String node_type = jb.get("node_type").getAsString();
         ITransTemplateCopyService service = (ITransTemplateCopyService)ServiceLocator.find(ITransTemplateCopyService.class);
         service.copyGlobalFromC0ToDL(sys_pk, pk_group, pk_org, node_type);
      } catch (Exception var9) {
         ExceptionUtils.wrapException(var9);
      }

      return null;
   }
}
