package nccloud.web.fip.transtemplate.action;

import nc.vo.fip.transtemplate.TransTemplateVO;
import nccloud.dto.fip.transtemplate.TransTemplateWebVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateCopyService;
import nccloud.web.fip.transtemplate.adapter.TransTemplateAdapter;

public class TemplateCopyByOrgAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         TransTemplateWebVO templateWebVO = (TransTemplateWebVO)JsonFactory.create().fromJson(e, TransTemplateWebVO.class);
         TransTemplateVO templateConvertVO = TransTemplateAdapter.trans2TemplateVO(templateWebVO);
         String pk_transtemplate = templateConvertVO.getPk_transtemplate();
         String[] orgs = templateWebVO.getCopyDesPrams();
         String copyDesFactor1 = templateWebVO.getCopyDesFactor1();
         if(templateConvertVO != null) {
            ((ITransTemplateCopyService)ServiceLocator.find(ITransTemplateCopyService.class)).copyTemplateByOrg(pk_transtemplate, orgs, copyDesFactor1);
         }
      } catch (Exception var8) {
         ExceptionUtils.wrapException(var8);
      }

      return null;
   }
}
