package nccloud.web.fip.transtemplate.action;

import java.util.HashMap;
import java.util.Map;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class FormulaTranslateAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      Map paraMap = (Map)JsonFactory.create().fromJson(json, Map.class);
      HashMap result = new HashMap();
      result.put("transferFlag", Boolean.valueOf(true));

      try {
         String ex = (String)paraMap.get("formula");
         String pk_group = (String)paraMap.get("pk_group");
         String pk_org = (String)paraMap.get("des_org");
         String src_billtype = (String)paraMap.get("src_billtype");
         String des_billtype = (String)paraMap.get("des_billtype");
         String desFactor1 = (String)paraMap.get("desFactor1Pk");
         if(ex != null && pk_org != null && src_billtype != null && des_billtype != null) {
            if(pk_group == null) {
               pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
            }

            String formula2 = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertCellFormula(ex, pk_group, pk_org, src_billtype, des_billtype, desFactor1);
            if(ex.equals(formula2) || formula2.contains("null")) {
               result.put("transferFlag", Boolean.valueOf(false));
            }

            result.put("data", formula2);
            return result;
         } else {
            result.put("transferFlag", Boolean.valueOf(false));
            result.put("data", (Object)null);
            return result;
         }
      } catch (BusinessException var12) {
         ExceptionUtils.wrapException(var12);
         result.put("transferFlag", Boolean.valueOf(false));
         result.put("data", (Object)null);
         return result;
      }
   }
}
