package nccloud.web.fip.templateassign.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nc.vo.fip.templateassign.TemplateassignVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.pubitf.fip.transtemplate.ITransTemplateAssignService;
import nccloud.web.fip.templateassign.action.TemplateassignSaveParamVO;

public class TemplateassignSaveAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      IJson iJson = JsonFactory.create();
      TemplateassignSaveParamVO paramVo = (TemplateassignSaveParamVO)iJson.fromJson(json, TemplateassignSaveParamVO.class);
      String src_pk = paramVo.getSrc_pk();
      String src_billtype = paramVo.getSrc_billtype();
      String trantype = paramVo.getTrantype();
      Object list = new ArrayList();

      try {
         List e = paramVo.getRows();

         for(int i = 0; i < e.size(); ++i) {
            Map cellMap = ((Row)e.get(i)).getValues();
            TemplateassignVO translateVo = this.translateVo(cellMap);
            ((List)list).add(translateVo);
         }

         list = ((ITransTemplateAssignService)ServiceLocator.find(ITransTemplateAssignService.class)).save((List)list, src_pk, src_billtype, trantype);
      } catch (BusinessException var13) {
         ExceptionUtils.wrapException(var13);
      }

      return Integer.valueOf(((List)list).size());
   }

   private TemplateassignVO translateVo(Map map) {
      TemplateassignVO vo = new TemplateassignVO();
      if(!isEmptyWithTrim((Cell)map.get("pk_org"))) {
         vo.setPk_org((String)((Cell)map.get("pk_org")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("account_type"))) {
         vo.setAccount_type((String)((Cell)map.get("account_type")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("pk_glsumrule"))) {
         vo.setPk_glsumrule((String)((Cell)map.get("pk_glsumrule")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("glvouchertype"))) {
         vo.setGlvouchertype((String)((Cell)map.get("glvouchertype")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("pk_rasumrule"))) {
         vo.setPk_rasumrule((String)((Cell)map.get("pk_rasumrule")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("ravouchertype"))) {
         vo.setRavouchertype((String)((Cell)map.get("ravouchertype")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def1"))) {
         vo.setDef1((String)((Cell)map.get("def1")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def2"))) {
         vo.setDef2((String)((Cell)map.get("def2")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def3"))) {
         vo.setDef3((String)((Cell)map.get("def3")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def4"))) {
         vo.setDef4((String)((Cell)map.get("def4")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def5"))) {
         vo.setDef5((String)((Cell)map.get("def5")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def6"))) {
         vo.setDef6((String)((Cell)map.get("def6")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def7"))) {
         vo.setDef7((String)((Cell)map.get("def7")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def8"))) {
         vo.setDef8((String)((Cell)map.get("def8")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def9"))) {
         vo.setDef9((String)((Cell)map.get("def9")).getValue());
      }

      if(!isEmptyWithTrim((Cell)map.get("def10"))) {
         vo.setDef10((String)((Cell)map.get("def10")).getValue());
      }

      return vo;
   }

   private static boolean isEmptyWithTrim(Cell cell) {
      return cell == null || cell.getValue() == null;
   }
}
