package nccloud.web.fip.templateassign.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.gl.fip.IVoucherSumRuleQryService;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.pub.FipBaseDataProxy;
import nc.vo.fip.templateassign.TemplateassignVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.voucher.fip.Aggcombinscheme;
import nc.vo.voucher.fip.CombinschemeVO;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.Condition;
import nccloud.dto.baseapp.querytree.dataformat.QueryTreeFormatVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.GridModel;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;
import nccloud.pubitf.fip.transtemplate.ITransTemplateAssignService;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;
import nccloud.pubitf.platform.query.INCCloudQueryService;

public class TemplateAssignQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String read = request.read();
      IJson json = JsonFactory.create();
      Grid result = null;
      AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(read, AccountingQueryPageInfo.class);

      try {
         String e = " 1 = 1 ";
         if(info != null && info.getQueryInfo() != null) {
            INCCloudQueryService service = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
            IQueryScheme vos = service.convertCondition(this.translateQueryInfo(info.getQueryInfo()));
            if(vos != null && vos.getWhereSQLOnly() != null) {
               e = vos.getWhereSQLOnly();
            }
         }

         ITransTemplateAssignService var27 = (ITransTemplateAssignService)ServiceLocator.find(ITransTemplateAssignService.class);
         TemplateassignVO[] var28 = var27.queryTemplateAssignList(e);
         PageInfo pageInfo = new PageInfo();
         if(var28 != null && var28.length > 0) {
            String[] var29 = new String[var28.length];
            TemplateassignVO vo = null;

            for(int rows = 0; rows < var28.length; ++rows) {
               vo = var28[rows];
               var29[rows] = vo.getPk_assign();
            }

            result = this.convert(var28, var29, info);
            pageInfo.setTotal(var29.length);
            if(info != null && info.getQueryInfo() != null && info.getQueryInfo().getPageInfo() != null) {
               pageInfo.setPageSize(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue());
               pageInfo.setPageIndex(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageIndex()).intValue());
            }

            pageInfo.setTotalPage(this.getTotalPage(pageInfo, var29.length));
            result.getModel().setPageinfo(pageInfo);
            Row[] var30 = result.getModel().getRows();
            if(var30 != null && var30.length > 0) {
               Aggcombinscheme scheme = null;
               String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
               Row[] var15 = var30;
               int var16 = var30.length;

               for(int var17 = 0; var17 < var16; ++var17) {
                  Row row = var15[var17];
                  Cell gl_sumrule = row.getCell("pk_glsumrule");
                  if(StringUtils.isNotEmpty((String)gl_sumrule.getValue())) {
                     scheme = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)gl_sumrule.getValue());
                     if(scheme != null && scheme.getParentVO() != null) {
                        CombinschemeVO ra_sumrule = (CombinschemeVO)scheme.getParentVO();
                        gl_sumrule.setDisplay(StringUtils.isNotEmpty(ra_sumrule.getName())?ra_sumrule.getName():ra_sumrule.getCode());
                     }
                  }

                  Cell var31 = row.getCell("pk_rasumrule");
                  if(var31 != null && var31.getValue() != null && var31.getValue().toString().length() > 0) {
                     scheme = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)var31.getValue());
                     if(scheme != null && scheme.getParentVO() != null) {
                        CombinschemeVO glVouchertype = (CombinschemeVO)scheme.getParentVO();
                        var31.setDisplay(StringUtils.isNotEmpty(glVouchertype.getName())?glVouchertype.getName():glVouchertype.getCode());
                     }
                  }

                  Cell var32 = row.getCell("glvouchertype");
                  if(var32 != null && var32.getValue() != null && var32.getValue().toString().length() > 0) {
                     String raVouchertype = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertCellFormula(var32.getValue().toString(), (String)null, (String)null, (String)null, (String)null, (String)null);
                     var32.setDisplay(raVouchertype);
                  }

                  Cell var33 = row.getCell("ravouchertype");
                  if(var33 != null && var33.getValue() != null && var33.getValue().toString().length() > 0) {
                     String srcBillTypeCell = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertCellFormula(var33.getValue().toString(), (String)null, (String)null, (String)null, (String)null, (String)null);
                     var33.setDisplay(srcBillTypeCell);
                  }

                  Cell var34 = row.getCell("src_billtype");
                  if(var34 != null && StringUtils.isBlank(var34.getDisplay()) && var34.getValue() != null) {
                     String billTypeCode = (String)var34.getValue();
                     BilltypeVO billtypeVO = FipBaseDataProxy.getBilltype(pk_group, billTypeCode.trim());
                     if(billtypeVO != null && StringUtils.isNotBlank(billtypeVO.getBilltypename())) {
                        billTypeCode.setDisplay(billtypeVO.getBilltypename());
                     }
                  }
               }
            }
         } else {
            result = new Grid();
            result.setPageid("10170503_1017050301");
            result.setTempletid("1001Z310000000006OTR");
            GridModel gridModel = new GridModel();
            gridModel.setAreacode("recordTable");
            gridModel.setPageinfo(pageInfo);
            gridModel.setAllpks(new String[0]);
            pageInfo.setTotal(0);
            if(info != null && info.getQueryInfo() != null && info.getQueryInfo().getPageInfo() != null) {
               pageInfo.setPageSize(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue());
               pageInfo.setPageIndex(Integer.valueOf(info.getQueryInfo().getPageInfo().getPageIndex()).intValue());
            }

            pageInfo.setTotalPage(0);
            result.setModel(gridModel);
         }
      } catch (BusinessException var26) {
         ExceptionUtils.wrapException(var26);
      }

      return result;
   }

   private QueryTreeFormatVO translateQueryInfo(QueryTreeFormatVO queryInfo) throws BusinessException {
      List conditions = queryInfo.getQuerycondition().getConditions();
      if(conditions != null && conditions.size() > 0) {
         Iterator var3 = conditions.iterator();

         while(var3.hasNext()) {
            Condition con = (Condition)var3.next();
            if("pk_billtype".equals(con.getField()) || "src_billtype".equals(con.getField())) {
               String[] pks = con.getValue().getFirstvalue().split(",");
               if(pks != null && pks.length > 0) {
                  String srcCode = "";
                  List billtypes = ((IBillTypeService)ServiceLocator.find(IBillTypeService.class)).queryByPks(pks);
                  ArrayList pklist = new ArrayList(Arrays.asList(pks));
                  int j;
                  if(billtypes != null && billtypes.size() > 0) {
                     for(j = 0; j < billtypes.size(); ++j) {
                        if(j == 0) {
                           srcCode = ((BilltypeVO)billtypes.get(j)).getPk_billtypecode();
                        } else {
                           srcCode = ((BilltypeVO)billtypes.get(j)).getPk_billtypecode();
                        }

                        if(pklist.contains(((BilltypeVO)billtypes.get(j)).getPk_billtypeid())) {
                           pklist.remove(((BilltypeVO)billtypes.get(j)).getPk_billtypeid());
                        }
                     }
                  }

                  if(pklist.size() > 0) {
                     for(j = 0; j < pklist.size(); ++j) {
                        if("".equals(srcCode)) {
                           if(j == 0) {
                              srcCode = (String)pklist.get(j);
                           } else {
                              srcCode = (String)pklist.get(j);
                           }
                        } else {
                           srcCode = (String)pklist.get(j);
                        }
                     }
                  }

                  con.getValue().setFirstvalue(srcCode);
               }
            }
         }
      }

      return queryInfo;
   }

   private Grid convert(TemplateassignVO[] vos, String[] pks, AccountingQueryPageInfo info) {
      int copySize = vos.length < Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue()?vos.length:Integer.valueOf(info.getQueryInfo().getPageInfo().getPageSize()).intValue();
      Grid grid = null;
      if(vos != null) {
         TemplateassignVO[] heads = new TemplateassignVO[copySize];

         for(int operator = 0; operator < copySize; ++operator) {
            heads[operator] = vos[operator];
         }

         GridOperator var8 = new GridOperator("1001Z310000000006OTR", info.getPagecode());
         grid = var8.toGrid(heads);
         grid.getModel().setAllpks(pks);
      }

      return grid;
   }

   private int getTotalPage(PageInfo pageInfo, int len) {
      int size = pageInfo.getPageSize();
      boolean total = false;
      int total1;
      if(len % size == 0) {
         total1 = len / size;
      } else {
         total1 = len / size + 1;
      }

      return total1;
   }
}
