package nccloud.web.fip.templateassign.action;

import nc.itf.gl.fip.IVoucherSumRuleQryService;
import nc.vo.fip.pub.SqlTools;
import nc.vo.fip.templateassign.TemplateassignVO;
import nc.vo.pub.BusinessException;
import nc.vo.voucher.fip.Aggcombinscheme;
import nc.vo.voucher.fip.CombinschemeVO;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.pubitf.fip.formula.AccountingQueryPageInfo;
import nccloud.pubitf.fip.transtemplate.ITransTemplateAssignService;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class TemplateAssignPageQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String read = request.read();
      IJson json = JsonFactory.create();
      Grid result = null;
      AccountingQueryPageInfo info = (AccountingQueryPageInfo)json.fromJson(read, AccountingQueryPageInfo.class);

      try {
         String e = " 1 = 1 ";
         if(info != null && info.getAllpks() != null) {
            e = SqlTools.getInStr("pk_assign", info.getAllpks(), true);
         }

         ITransTemplateAssignService service = (ITransTemplateAssignService)ServiceLocator.find(ITransTemplateAssignService.class);
         TemplateassignVO[] vos = service.queryTemplateAssignList(e);
         if(vos != null && vos.length > 0) {
            GridOperator operator = new GridOperator("1001Z310000000006OTR", info.getPagecode());
            result = operator.toGrid(vos);
            Row[] rows = result.getModel().getRows();
            if(rows != null && rows.length > 0) {
               Aggcombinscheme scheme = null;
               Row[] var12 = rows;
               int var13 = rows.length;

               for(int var14 = 0; var14 < var13; ++var14) {
                  Row row = var12[var14];
                  Cell gl_sumrule = row.getCell("pk_glsumrule");
                  if(StringUtils.isNotEmpty((String)gl_sumrule.getValue())) {
                     scheme = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)gl_sumrule.getValue());
                     if(scheme != null && scheme.getParentVO() != null) {
                        CombinschemeVO ra_sumrule = (CombinschemeVO)scheme.getParentVO();
                        gl_sumrule.setDisplay(StringUtils.isNotEmpty(ra_sumrule.getName())?ra_sumrule.getName():ra_sumrule.getCode());
                     }
                  }

                  Cell var22 = row.getCell("pk_rasumrule");
                  if(var22 != null && var22.getValue() != null && var22.getValue().toString().length() > 0) {
                     scheme = ((IVoucherSumRuleQryService)ServiceLocator.find(IVoucherSumRuleQryService.class)).queryByID((String)var22.getValue());
                     if(scheme != null && scheme.getParentVO() != null) {
                        CombinschemeVO glVouchertype = (CombinschemeVO)scheme.getParentVO();
                        var22.setDisplay(StringUtils.isNotEmpty(glVouchertype.getName())?glVouchertype.getName():glVouchertype.getCode());
                     }
                  }

                  Cell var23 = row.getCell("glvouchertype");
                  if(var23 != null && var23.getValue() != null && var23.getValue().toString().length() > 0) {
                     String raVouchertype = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertCellFormula(var23.getValue().toString(), (String)null, (String)null, (String)null, (String)null, (String)null);
                     var23.setDisplay(raVouchertype);
                  }

                  Cell var24 = row.getCell("ravouchertype");
                  if(var24 != null && var24.getValue() != null && var24.getValue().toString().length() > 0) {
                     String ravochertypename = ((ITransTemplateService)ServiceLocator.find(ITransTemplateService.class)).convertCellFormula(var24.getValue().toString(), (String)null, (String)null, (String)null, (String)null, (String)null);
                     var24.setDisplay(ravochertypename);
                  }
               }
            }
         }
      } catch (BusinessException var21) {
         ExceptionUtils.wrapException(var21);
      }

      return result;
   }
}
