package nccloud.web.fip.reconwb.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nc.itf.fip.cache.memcache.ReconSystemCache;
import nc.itf.fip.cache.memcache.ReconSystemMapCache;
import nc.vo.fip.reconsysreg.AggReconSystemMapVO;
import nc.vo.fip.reconsysreg.AggReconSystemVO;
import nc.vo.fip.reconsysreg.ReconAmtTypeRelationVO;
import nc.vo.fip.reconsysreg.ReconSysAmntTypeVO;
import nc.vo.fip.reconsysreg.ReconSysDefColVO;
import nc.vo.fip.reconsysreg.ReconSysOrgDimVO;
import nc.vo.fip.reconsysreg.ReconSystemVO;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;

public class ReconSystemUtil {

   public static ReconSystemSingleVO getReconSystem(String moduleId, String isSrc, String otherModuleId) {
      ReconSystemSingleVO singleVO = null;
      AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId(moduleId);
      if(Objects.nonNull(systemVO)) {
         singleVO = new ReconSystemSingleVO();
         singleVO.setReconsystem(systemVO.getParentVO(), "Y".equals(isSrc));
         singleVO.setAmttype((ReconSysAmntTypeVO[])systemVO.getChildren(ReconSysAmntTypeVO.class));
         singleVO.setOrgdim((ReconSysOrgDimVO[])systemVO.getChildren(ReconSysOrgDimVO.class));
         singleVO.setDefcols((ReconSysDefColVO[])systemVO.getChildren(ReconSysDefColVO.class));
         singleVO.setDim(systemVO.getReconSysDimVO());
         if(StringUtils.isNotEmpty(moduleId) && StringUtils.isNotEmpty(otherModuleId)) {
            AggReconSystemVO systemVO2 = ReconSystemCache.getReconSystemByModuleId(otherModuleId);
            String srcModulePk;
            String desModulePK;
            AggReconSystemVO srcSystemVO;
            AggReconSystemVO desSystemVO;
            if("Y".equals(isSrc)) {
               srcModulePk = systemVO.getParentVO().getPk_reconsystem();
               desModulePK = systemVO2.getParentVO().getPk_reconsystem();
               srcSystemVO = systemVO;
               desSystemVO = systemVO2;
            } else {
               srcModulePk = systemVO2.getParentVO().getPk_reconsystem();
               desModulePK = systemVO.getParentVO().getPk_reconsystem();
               srcSystemVO = systemVO2;
               desSystemVO = systemVO;
            }

            AggReconSystemMapVO vo = ReconSystemMapCache.getReconSystemByModuleIdList(srcModulePk, desModulePK);
            ReconAmtTypeRelationVO[] vos = vo.getReconAmtTypeRelationVO();
            singleVO.setAmtTypeList(srcSystemVO, desSystemVO, vos);
         }
      }

      return singleVO;
   }

   public static ReconSystemSingleVO getReconSystemOnlyAmtTypeList(String moduleId, String isSrc, String otherModuleId) {
      ReconSystemSingleVO singleVO = null;
      AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId(moduleId);
      if(Objects.nonNull(systemVO)) {
         singleVO = new ReconSystemSingleVO();
         if(StringUtils.isNotEmpty(moduleId) && StringUtils.isNotEmpty(otherModuleId)) {
            AggReconSystemVO systemVO2 = ReconSystemCache.getReconSystemByModuleId(otherModuleId);
            String srcModulePk;
            String desModulePK;
            AggReconSystemVO srcSystemVO;
            AggReconSystemVO desSystemVO;
            if("Y".equals(isSrc)) {
               srcModulePk = systemVO.getParentVO().getPk_reconsystem();
               desModulePK = systemVO2.getParentVO().getPk_reconsystem();
               srcSystemVO = systemVO;
               desSystemVO = systemVO2;
            } else {
               srcModulePk = systemVO2.getParentVO().getPk_reconsystem();
               desModulePK = systemVO.getParentVO().getPk_reconsystem();
               srcSystemVO = systemVO2;
               desSystemVO = systemVO;
            }

            AggReconSystemMapVO vo = ReconSystemMapCache.getReconSystemByModuleIdList(srcModulePk, desModulePK);
            ReconAmtTypeRelationVO[] vos = vo.getReconAmtTypeRelationVO();
            singleVO.setAmtTypeList(srcSystemVO, desSystemVO, vos);
         }
      }

      return singleVO;
   }

   public static List getAllReconSystem(String isSrc) {
      ArrayList reconSystemSingleVOList = new ArrayList();
      AggReconSystemVO[] aggReconSystemVOS = ReconSystemCache.getReconSystemByModuleByIsSrc(isSrc);
      if(ArrayUtils.isNotEmpty(aggReconSystemVOS)) {
         AggReconSystemVO[] var3 = aggReconSystemVOS;
         int var4 = aggReconSystemVOS.length;

         for(int var5 = 0; var5 < var4; ++var5) {
            AggReconSystemVO aggReconSystemVO = var3[var5];
            ReconSystemSingleVO singleVO = new ReconSystemSingleVO();
            reconSystemSingleVOList.add(singleVO);
            singleVO.setReconsystem(aggReconSystemVO.getParentVO(), "Y".equals(isSrc));
         }
      }

      return reconSystemSingleVOList;
   }

   public static List getOnlyReconSystem(String[] moduleIds, String[] isSrc) {
      if(Objects.isNull(moduleIds)) {
         return new ArrayList();
      } else {
         ArrayList reconSystemSingleVOList = new ArrayList();

         for(int i = 0; i < moduleIds.length; ++i) {
            ReconSystemSingleVO singleVO = getOnlyReconSystem((String)moduleIds[i], (String)isSrc[i]);
            if(Objects.nonNull(singleVO)) {
               reconSystemSingleVOList.add(singleVO);
            }
         }

         return reconSystemSingleVOList;
      }
   }

   public static ReconSystemSingleVO getOnlyReconSystem(String moduleId, String isSrc) {
      ReconSystemSingleVO singleVO = null;
      AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId(moduleId);
      if(Objects.nonNull(systemVO)) {
         singleVO = new ReconSystemSingleVO();
         singleVO.setReconsystem(systemVO.getParentVO(), UFBoolean.valueOf(isSrc).booleanValue());
      }

      return singleVO;
   }

   public static List getReconSystemsWithAmtTypeMap(String[] moduleIds, String isSrc, String otherModuleId) {
      if(Objects.isNull(moduleIds)) {
         return new ArrayList();
      } else {
         ArrayList reconSystemSingleVOList = new ArrayList();
         String[] var4 = moduleIds;
         int var5 = moduleIds.length;

         for(int var6 = 0; var6 < var5; ++var6) {
            String moduleId = var4[var6];
            ReconSystemSingleVO singleVO = getReconSystem(moduleId, isSrc, otherModuleId);
            if(Objects.nonNull(singleVO)) {
               reconSystemSingleVOList.add(singleVO);
            }
         }

         return reconSystemSingleVOList;
      }
   }

   public static ReconSystemSingleVO[] getReconSystemVOs(String[] moduleIds, String isSrc) {
      ArrayList singleVOs = new ArrayList();
      AggReconSystemVO[] systemVOs = ReconSystemCache.getReconSystemByModuleIdList(moduleIds);
      if(ArrayUtils.isNotEmpty(systemVOs)) {
         AggReconSystemVO[] var4 = systemVOs;
         int var5 = systemVOs.length;

         for(int var6 = 0; var6 < var5; ++var6) {
            AggReconSystemVO systemVO = var4[var6];
            ReconSystemSingleVO singleVO = new ReconSystemSingleVO();
            singleVOs.add(singleVO);
            singleVO.setReconsystem(systemVO.getParentVO(), "Y".equals(isSrc));
            singleVO.setAmttype((ReconSysAmntTypeVO[])systemVO.getChildren(ReconSysAmntTypeVO.class));
            singleVO.setOrgdim((ReconSysOrgDimVO[])systemVO.getChildren(ReconSysOrgDimVO.class));
            singleVO.setDefcols((ReconSysDefColVO[])systemVO.getChildren(ReconSysDefColVO.class));
         }
      }

      return (ReconSystemSingleVO[])singleVOs.toArray(new ReconSystemSingleVO[0]);
   }

   public static ReconSystemVO getLinkUrl(String moduleId, String isSrc) {
      AggReconSystemVO systemVO = ReconSystemCache.getReconSystemByModuleId(moduleId);
      return "Y".equals(isSrc)?systemVO.getParentVO():systemVO.getParentVO();
   }
}
