package nccloud.web.fip.reconwb.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.pubitf.org.IOrgUnitPubService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nc.vo.fip.reconsetting.ReconSettingDefColVO;
import nc.vo.fip.reconsetting.ReconSettingVO;
import nc.vo.fip.reconsysreg.ReconSysDefColVO;
import nc.vo.ml.MultiLangContext;
import nc.vo.org.OrgVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.collections.MapUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCard;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.web.fip.reconwb.utils.ReconAmtUtil;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;

public class RcpSettingCardUtil {

   public static void afterToCard(ExtBillCard card, AggReconSettingVO reconSettingVO) throws BusinessException {
      setDesOrSrcSystemDisplayAndSysReg(card);
      setExcludesOrgAndDefColIntoCard(card, reconSettingVO);
      dealDimProperty(card);
   }

   public static void setCurrentLang(AggReconSettingVO aggReconSettingVO) throws BusinessException {
      ReconSettingVO reconSettingVO = aggReconSettingVO.getParentVO();
      Object currLangIndex = MultiLangContext.getInstance().getCurrentLangSeq().intValue();
      String name = reconSettingVO.getName();
      if(StringUtils.isNotBlank(name) && currLangIndex != 1) {
         String currentName = (String)reconSettingVO.getAttributeValue((String)currLangIndex);
         if(StringUtils.isBlank(currentName)) {
            reconSettingVO.setAttributeValue((String)currLangIndex, name);
         }
      }

   }

   private static void dealDimProperty(ExtBillCard card) throws BusinessException {
      Grid bodyDimGrid = card.getBody("body_dim");
      if(!Objects.isNull(bodyDimGrid) && !Objects.isNull(bodyDimGrid.getModel())) {
         List rows = bodyDimGrid.getModel().getListRows();
         if(CollectionUtils.isNotEmpty(rows)) {
            Iterator var3 = rows.iterator();

            while(var3.hasNext()) {
               Row row = (Row)var3.next();
               setPropertyCell(row.getCell("pk_dim_src.metaid"), row.getCell("dim_src_proppath"));
               setPropertyCell(row.getCell("pk_dim_des.metaid"), row.getCell("dim_des_proppath"));
            }
         }

      }
   }

   private static void setPropertyCell(Cell metaCell, Cell propertyCell) throws BusinessException {
      if(!Objects.isNull(metaCell) && !Objects.isNull(metaCell.getValue()) && !Objects.isNull(propertyCell) && !Objects.isNull(propertyCell.getValue())) {
         String metaId = (String)metaCell.getValue();
         String property = (String)propertyCell.getValue();
         String name = ((IReconSettingService)ServiceLocator.find(IReconSettingService.class)).getDimPropertyName(metaId, property.split("#")[0]);
         if(StringUtils.isNotEmpty(name)) {
            propertyCell.setDisplay(name);
         }

      }
   }

   public static void setDesOrSrcSystemDisplayAndSysReg(ExtBillCard card) {
      HashMap reconSystemMap = new HashMap(2);
      if(Objects.nonNull(card) && Objects.nonNull(card.getHead()) && Objects.nonNull(card.getHead().getModel())) {
         String json = null;
         String pk_system_src = null;
         List rows = card.getHead().getModel().getListRows();
         if(CollectionUtils.isNotEmpty(rows)) {
            Map amtRows = ((Row)rows.get(0)).getValues();
            if(MapUtils.isNotEmpty(amtRows)) {
               Cell desSystemCell = (Cell)amtRows.get("pk_system_des");
               Cell desSystemNameCell = (Cell)amtRows.get("pk_system_des.moduleid");
               if(Objects.nonNull(desSystemCell) && Objects.nonNull(desSystemNameCell) && Objects.nonNull(desSystemCell.getValue()) && StringUtils.isNotEmpty(desSystemNameCell.getDisplay())) {
                  desSystemCell.setDisplay(desSystemNameCell.getDisplay());
                  reconSystemMap.put("des_system", ReconSystemUtil.getReconSystem((String)desSystemCell.getValue(), "N", (String)null));
                  json = (String)desSystemCell.getValue();
               }

               Cell srcSystemCell = (Cell)amtRows.get("pk_system_src");
               Cell row = (Cell)amtRows.get("pk_system_src.moduleid");
               if(Objects.nonNull(srcSystemCell) && Objects.nonNull(row) && Objects.nonNull(srcSystemCell.getValue()) && StringUtils.isNotEmpty(row.getDisplay())) {
                  srcSystemCell.setDisplay(row.getDisplay());
                  reconSystemMap.put("src_system", ReconSystemUtil.getReconSystem((String)srcSystemCell.getValue(), "Y", (String)null));
                  pk_system_src = (String)srcSystemCell.getValue();
               }

               if(StringUtils.isNotEmpty(pk_system_src) && StringUtils.isNotEmpty(json)) {
                  reconSystemMap.put("amtType", ReconSystemUtil.getReconSystemOnlyAmtTypeList(pk_system_src, "Y", json));
               }
            }
         }

         if(Objects.nonNull(card.getBody("amounttype_table")) && Objects.nonNull(card.getBody("amounttype_table").getModel())) {
            Row[] var16 = card.getBody("amounttype_table").getModel().getRows();
            if(ArrayUtils.isNotEmpty(var16)) {
               Row[] var17 = var16;
               int var18 = var16.length;

               for(int var19 = 0; var19 < var18; ++var19) {
                  Row var20 = var17[var19];
                  Cell descell = var20.getCell("formula_des");
                  String formula_des = (String)descell.getValue();
                  if(!StringUtils.isEmpty(formula_des)) {
                     String srccell = ReconAmtUtil.formulaTranslator(formula_des, json);
                     descell.setDisplay(srccell);
                  }

                  Cell var21 = var20.getCell("formula_src");
                  String formula_src = (String)var21.getValue();
                  if(!StringUtils.isEmpty(formula_src)) {
                     String display_src = ReconAmtUtil.formulaTranslator(formula_src, pk_system_src);
                     var21.setDisplay(display_src);
                  }
               }
            }
         }
      }

      IJson var15 = JsonFactory.create();
      card.setUserjson(var15.toJson(reconSystemMap));
   }

   public static void setExcludesOrgAndDefColIntoCard(ExtBillCard param0, AggReconSettingVO param1) throws BusinessException {
      // $FF: Couldn't be decompiled
   }

   private static String getDisplay(List valueList, Map displayMap) {
      ArrayList display = new ArrayList();
      Iterator var3 = valueList.iterator();

      while(var3.hasNext()) {
         String s = (String)var3.next();
         display.add((String)displayMap.getOrDefault(s, s));
      }

      return String.join(",", display);
   }

   private static String getDefColDisplay(ReconSysDefColVO defColVO, int currLangIndex) {
      if(Objects.isNull(defColVO)) {
         return null;
      } else {
         String display;
         if(currLangIndex == 1) {
            display = defColVO.getName();
         } else {
            display = (String)defColVO.getAttributeValue((String)currLangIndex);
         }

         return display;
      }
   }

   private static Map getOrgNameMap(List pkList, int currLangIndex) throws BusinessException {
      HashMap displayMap = new HashMap();
      if(CollectionUtils.isNotEmpty(pkList)) {
         IOrgUnitPubService orgUnitPubService = (IOrgUnitPubService)ServiceLocator.find(IOrgUnitPubService.class);
         OrgVO[] orgs = orgUnitPubService.getOrgs((String[])pkList.toArray(new String[0]), (String[])null);
         if(ArrayUtils.isNotEmpty(orgs)) {
            OrgVO[] var5 = orgs;
            int var6 = orgs.length;

            for(int var7 = 0; var7 < var6; ++var7) {
               OrgVO org = var5[var7];
               String name = org.getName();
               String otherName = (String)org.getAttributeValue((String)currLangIndex);
               String display;
               if(currLangIndex == true) {
                  display = name;
               } else if(StringUtils.isNotEmpty(otherName)) {
                  display = otherName;
               } else {
                  display = name;
               }

               displayMap.put(org.getPk_org(), display);
            }
         }
      }

      return displayMap;
   }

   // $FF: synthetic method
   private static ReconSettingDefColVO[] lambda$setExcludesOrgAndDefColIntoCard$0(int x$0) {
      return new ReconSettingDefColVO[x$0];
   }
}
