package nccloud.web.fip.reconwb.action;

import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.reconsetting.IReconSysRegQueryService;
import nc.itf.uap.bbd.func.IModuleQueryService;
import nc.vo.fip.reconsysreg.AggReconSystemVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nc.vo.sm.funcreg.ModuleVO;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class ReconSysInfoQryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map params = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
      String moduleid = (String)params.get("moduleid");
      String pk_reconsystem = (String)params.get("pk_reconsystem");

      try {
         AggReconSystemVO e = null;
         if(StringUtils.isNotEmpty(moduleid)) {
            e = ((IReconSysRegQueryService)ServiceLocator.find(IReconSysRegQueryService.class)).queryReconSysRegByModuleId(moduleid);
         } else {
            e = ((IReconSysRegQueryService)ServiceLocator.find(IReconSysRegQueryService.class)).queryReconSysRegByPk(pk_reconsystem);
         }

         ModuleVO moduleVO = ((IModuleQueryService)ServiceLocator.find(IModuleQueryService.class)).getModule(e.getParentVO().getModuleid());
         HashMap result = new HashMap();
         result.put("pk_reconsystem", e.getPrimaryKey());
         result.put("modulename", NCLangRes4VoTransl.getNCLangRes().getStrByID("funcode", moduleVO.getResid()));
         result.put("orgtype", e.getParentVO().getOrgtype());
         result.put("orgref", e.getParentVO().getOrgref());
         return result;
      } catch (BusinessException var8) {
         ExceptionUtils.wrapBusinessException(var8.getMessage(), var8);
         return null;
      }
   }
}
