package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.cache.memcache.ReconSystemCache;
import nc.itf.fip.reconsetting.IBusiReconTransfor;
import nc.itf.org.IAccBookQryService;
import nc.vo.fip.reconsysreg.AggReconSystemVO;
import nc.vo.org.AccbookVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.ArrayUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class ReconQueryTypeTranslateAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
      Map jsonMap = (Map)paramMap.get("json");
      String json = (String)jsonMap.get("value");
      String moduleId = (String)paramMap.get("moduleid");
      if(StringUtils.isEmpty(moduleId)) {
         return paramMap;
      } else {
         String pk_org_des = (String)paramMap.get("pk_org_des");
         String pk_org_src = (String)paramMap.get("pk_org_src");

         try {
            AggReconSystemVO e = ReconSystemCache.getReconSystemByModuleId(moduleId);
            String classname = e.getParentVO().getTranslateclass();
            Map map = this.getAccBookInfo(pk_org_des, pk_org_src);
            paramMap.put("accBookMap", map);
            if(StringUtils.isNotEmpty(classname)) {
               Class clazz = Class.forName(classname);
               IBusiReconTransfor transfer = (IBusiReconTransfor)clazz.newInstance();
               json = transfer.jsonTransferObject(json);
               jsonMap.put("value", json);
               paramMap.put("json", jsonMap);
            }
         } catch (Exception var13) {
            ExceptionUtils.wrapException(var13);
         }

         return paramMap;
      }
   }

   private Map getAccBookInfo(String pk_org_des, String pk_org_src) throws BusinessException {
      ArrayList pkList = new ArrayList();
      HashMap map = new HashMap();
      if(StringUtils.isNotBlank(pk_org_des)) {
         pkList.add(pk_org_des);
      }

      if(StringUtils.isNotBlank(pk_org_src)) {
         pkList.add(pk_org_src);
      }

      if(!pkList.isEmpty()) {
         AccbookVO[] accBookVOS = ((IAccBookQryService)ServiceLocator.find(IAccBookQryService.class)).queryVOsByPks((String[])pkList.toArray(new String[0]));
         if(ArrayUtils.isNotEmpty(accBookVOS)) {
            AccbookVO[] var6 = accBookVOS;
            int var7 = accBookVOS.length;

            for(int var8 = 0; var8 < var7; ++var8) {
               AccbookVO accBookVO = var6[var8];
               map.put(accBookVO.getPk_accbook(), accBookVO.getPk_relorg());
            }
         }
      }

      return map;
   }
}
