package nccloud.web.fip.reconwb.action;

import java.util.Map;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.StringUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;

public class RecSysRegQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
      String moduleId = (String)paramMap.get("moduleid");
      String onlySystem = (String)paramMap.get("onlySystem");
      String otherModuleId = (String)paramMap.get("othermoduleid");
      String[] moduleIds = null;
      if(StringUtils.isNotEmpty(moduleId)) {
         moduleIds = moduleId.split(",");
      }

      String isSrc = (String)paramMap.get("isSrc");

      try {
         return StringUtils.isNotBlank(onlySystem) && UFBoolean.valueOf(onlySystem).booleanValue()?ReconSystemUtil.getOnlyReconSystem(moduleIds, isSrc.split(",")):ReconSystemUtil.getReconSystemsWithAmtTypeMap(moduleIds, isSrc, otherModuleId);
      } catch (Exception var9) {
         ExceptionUtils.wrapException(var9);
         return null;
      }
   }
}
