package nccloud.web.fip.reconwb.action;

import java.util.Map;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class RecSettingVOQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
      String pk_reconsetting = (String)paramMap.get("pk_reconsetting");
      IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);
      AggReconSettingVO reconSetting = null;

      try {
         reconSetting = reconSettingService.findBillByPk(pk_reconsetting);
      } catch (BusinessException var7) {
         ExceptionUtils.wrapException(var7);
      }

      return reconSetting;
   }
}
