package nccloud.web.fip.reconwb.action;

import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import nc.itf.fip.reconexe.IReconExeService;
import nc.vo.fip.reconexe.ReconExeParameter;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import ssc.mq.util.Logger;

public class RcpWorkOneClickAction implements ICommonAction {

   public Object doAction(IRequest request) {
      IJson json = JsonFactory.create();
      ArrayList infos = (ArrayList)json.fromJson(request.read(), List.class);
      if(Objects.isNull(infos)) {
         return null;
      } else {
         IReconExeService iReconExeService = (IReconExeService)ServiceLocator.find(IReconExeService.class);
         ArrayList reconExeParameters = new ArrayList();
         String year_priod = ((LinkedTreeMap)infos.get(0)).get("year_period") == null?null:(String)((LinkedTreeMap)infos.get(0)).get("year_period");

         ReconExeParameter reconExeParameter;
         for(Iterator e = infos.iterator(); e.hasNext(); reconExeParameters.add(reconExeParameter)) {
            LinkedTreeMap info = (LinkedTreeMap)e.next();
            reconExeParameter = new ReconExeParameter();
            reconExeParameter.setReconSetting(info.get("pk_reconsetting") == null?null:(String)info.get("pk_reconsetting"));
            reconExeParameter.setOrgDes(info.get("pk_accbook") == null?null:(String)info.get("pk_accbook"));
            reconExeParameter.setYearMonth(year_priod);
            if(info.get("rowid") != null) {
               reconExeParameter.setRowid((String)info.get("rowid"));
            }
         }

         try {
            ArrayList exestatuslist = iReconExeService.reconExe(reconExeParameters);
            return exestatuslist;
         } catch (BusinessException var11) {
            Logger.error(var11.getMessage(), var11);
            throw new RuntimeException(var11.getMessage(), var11);
         }
      }
   }
}
