package nccloud.web.fip.reconwb.action;

import java.util.HashMap;
import java.util.Objects;
import nc.itf.fip.reconwork.IReconWorkService;
import nc.vo.fip.reconwork.ReconworkResultVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class RcpWorkListPageQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Grid grid = null;
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
      if(Objects.isNull(info)) {
         return null;
      } else {
         IReconWorkService iReconWorkService = (IReconWorkService)ServiceLocator.find(IReconWorkService.class);

         try {
            ReconworkResultVO[] e = iReconWorkService.findReconWorkListbypk(info.getPk_bills(), "pk_reconsetting");
            HashMap pkMap = new HashMap();
            ReconworkResultVO[] operator = e;
            int var9 = e.length;

            for(int var10 = 0; var10 < var9; ++var10) {
               ReconworkResultVO vo = operator[var10];
               pkMap.put(vo.getPk_reconsetting(), vo);
            }

            GridOperator var13 = new GridOperator(info.getPagecode());
            grid = var13.toGrid(e);
         } catch (BusinessException var12) {
            ExceptionUtils.wrapException(var12);
         }

         return grid;
      }
   }
}
