package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import nc.bs.framework.json.core.exception.ExceptionUtils;
import nc.itf.fip.opreatinglog.IBillTypeService;
import nc.itf.fip.pub.IModuleService;
import nc.pubitf.fip.service.IFipQueryService;
import nc.vo.fip.service.FipReconCheckBasicDataVO;
import nc.vo.fip.service.FipReconCheckQueryVO;
import nc.vo.fip.service.FipReconCheckResultVO;
import nc.vo.fip.service.FipReconWorkbenchTypeDataVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.billtype.BilltypeVO;
import nc.vo.pub.lang.UFDate;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.Condition;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.txmsgdata.action.SearchInfo;
import org.apache.commons.lang3.ArrayUtils;

public class RcpVoucherConvertQueryAction implements ICommonAction {

   public static final String OPERATINGLOG_FAILURE = "failure";
   public static final String OPERATINGLOG_TEMPVOUCHER = "tempvoucher";
   public static final String OPERATINGLOG_ZERO_VALUE = "zero";


   public Object doAction(IRequest request) {
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
      if(info != null && info.getQueryInfo() != null && info.getQueryInfo().getQuerycondition() != null) {
         try {
            List e = info.getQueryInfo().getQuerycondition().getConditions();
            if(e != null) {
               FipReconCheckQueryVO rcpCondition = new FipReconCheckQueryVO();
               Iterator result = e.iterator();

               while(result.hasNext()) {
                  Condition con = (Condition)result.next();
                  String firstvalue = con.getValue().getFirstvalue();
                  if(!StringUtils.isEmpty(firstvalue)) {
                     String var9 = con.getField();
                     byte var10 = -1;
                     switch(var9.hashCode()) {
                     case -1953166839:
                        if(var9.equals("src_org")) {
                           var10 = 5;
                        }
                        break;
                     case -1223198386:
                        if(var9.equals("des_billtype")) {
                           var10 = 1;
                        }
                        break;
                     case -741023808:
                        if(var9.equals("pk_des_system")) {
                           var10 = 0;
                        }
                        break;
                     case -65996526:
                        if(var9.equals("src_busidate")) {
                           var10 = 6;
                        }
                        break;
                     case 763975086:
                        if(var9.equals("pk_src_system")) {
                           var10 = 3;
                        }
                        break;
                     case 1556744503:
                        if(var9.equals("des_org")) {
                           var10 = 2;
                        }
                        break;
                     case 1971727292:
                        if(var9.equals("src_billtype")) {
                           var10 = 4;
                        }
                     }

                     switch(var10) {
                     case 0:
                        rcpCondition.setDes_syscode(firstvalue);
                        break;
                     case 1:
                        rcpCondition.setDes_billtype(this.getBillTypes(firstvalue)[0]);
                        break;
                     case 2:
                        rcpCondition.setDes_orgs(firstvalue.split(","));
                        break;
                     case 3:
                        rcpCondition.setSrc_syscodes(this.getDevModulesBySystemPKs(firstvalue));
                        break;
                     case 4:
                        rcpCondition.setSrc_billtypes(this.getBillTypes(firstvalue));
                        break;
                     case 5:
                        rcpCondition.setSrc_orgs(firstvalue.split(","));
                        break;
                     case 6:
                        rcpCondition.setBegindate(UFDate.getDate(firstvalue));
                        rcpCondition.setEnddate(UFDate.getDate(con.getValue().getSecondvalue()).asEnd());
                     }
                  }
               }

               FipReconCheckResultVO[] result1 = ((IFipQueryService)ServiceLocator.find(IFipQueryService.class)).queryReconCheckData(rcpCondition);
               return this.disposeResult(result1);
            }
         } catch (Exception var11) {
            ExceptionUtils.wrapException(var11);
         }

         return null;
      } else {
         return null;
      }
   }

   private Map disposeResult(FipReconCheckResultVO[] results) {
      if(ArrayUtils.isEmpty(results)) {
         return null;
      } else {
         HashMap resultMap = new HashMap();
         FipReconCheckResultVO[] var3 = results;
         int var4 = results.length;

         for(int var5 = 0; var5 < var4; ++var5) {
            FipReconCheckResultVO result = var3[var5];
            String des_billtype = result.getDes_billtype();
            Map dataMap = result.getDataMap();
            Iterator iterator = dataMap.entrySet().iterator();

            HashMap workbenchTypeDataMap;
            String keyName;
            Object detailMap;
            for(workbenchTypeDataMap = new HashMap(); iterator.hasNext(); workbenchTypeDataMap.put(keyName, detailMap)) {
               Entry entry = (Entry)iterator.next();
               Integer datatype = (Integer)entry.getKey();
               FipReconWorkbenchTypeDataVO workbenchTypeData = (FipReconWorkbenchTypeDataVO)entry.getValue();
               int checkdatanum = workbenchTypeData.getCheckdatanum() == null?0:workbenchTypeData.getCheckdatanum().intValue();
               List basicDataList = workbenchTypeData.getData();
               keyName = getKeyName(datatype);
               detailMap = (Map)workbenchTypeDataMap.get(keyName);
               int oriNum = 0;
               Object oriPks = new ArrayList();
               if(detailMap == null) {
                  detailMap = new HashMap();
               } else {
                  oriNum = ((Integer)((Map)detailMap).get("checkdatanum")).intValue();
                  oriPks = (List)((Map)detailMap).get("pks");
               }

               checkdatanum += oriNum;
               ArrayList pks = new ArrayList((Collection)oriPks);
               ((Map)detailMap).put("checkdatanum", Integer.valueOf(checkdatanum));
               ((Map)detailMap).put("pks", pks);
               if(CollectionUtils.isNotEmpty(basicDataList)) {
                  Iterator var21 = basicDataList.iterator();

                  while(var21.hasNext()) {
                     FipReconCheckBasicDataVO basicData = (FipReconCheckBasicDataVO)var21.next();
                     pks.add(basicData.getId());
                  }
               }
            }

            resultMap.put("desbilltype", des_billtype);
            resultMap.put("workbenchdata", workbenchTypeDataMap);
         }

         return resultMap;
      }
   }

   private static String getKeyName(Integer datatype) {
      String keyName;
      if(1 != datatype.intValue() && 2 != datatype.intValue()) {
         if(4 != datatype.intValue() && 5 != datatype.intValue()) {
            keyName = "zero";
         } else {
            keyName = "tempvoucher";
         }
      } else {
         keyName = "failure";
      }

      return keyName;
   }

   private String[] getBillTypes(String billTypeIdStr) {
      IBillTypeService billTypeService = (IBillTypeService)ServiceLocator.find(IBillTypeService.class);
      ArrayList billtypes = new ArrayList();
      if(StringUtils.isNotEmpty(billTypeIdStr)) {
         String[] pks = billTypeIdStr.split(",");

         try {
            billtypes.addAll(billTypeService.queryByPks(pks));
            ArrayList e = new ArrayList();
            if(CollectionUtils.isNotEmpty(billtypes)) {
               Iterator var6 = billtypes.iterator();

               while(var6.hasNext()) {
                  BilltypeVO billtype = (BilltypeVO)var6.next();
                  e.add(billtype.getPk_billtypecode());
               }
            }

            if(e.isEmpty()) {
               return new String[]{"NAV"};
            }

            return (String[])e.toArray(new String[0]);
         } catch (BusinessException var8) {
            ExceptionUtils.wrapException(var8);
         }
      }

      return null;
   }

   private String[] getDevModulesBySystemPKs(String reconSystemStr) {
      IModuleService moduleService = (IModuleService)ServiceLocator.find(IModuleService.class);
      if(StringUtils.isNotEmpty(reconSystemStr)) {
         String[] pks = reconSystemStr.split(",");

         try {
            return moduleService.qrySysCodesByReconSysPKs(pks);
         } catch (BusinessException var5) {
            ExceptionUtils.wrapException(var5);
         }
      }

      return null;
   }
}
