package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nc.vo.fip.reconsetting.ReconSettingDefColVO;
import nc.vo.fip.reconsetting.ReconSettingExcludeOrgVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.ISuperVO;
import nc.vo.pub.lang.UFBoolean;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.ExtBillCardConvertProcessor;
import nccloud.framework.web.ui.model.GridModel;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCard;
import nccloud.framework.web.ui.pattern.extbillcard.ExtBillCardOperator;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.web.fip.reconwb.utils.RcpSettingCardUtil;

public class RcpSettingSaveAction implements ICommonAction {

   public static final String EXCLUDE_ORG_KEY = "exclude_org";
   public static final String DEF_COL_KEY = "def_col";


   public Object doAction(IRequest request) {
      ExtBillCard billCard = (ExtBillCard)JsonFactory.create().fromJson(request.read(), ExtBillCard.class);
      ExtBillCardConvertProcessor processor = new ExtBillCardConvertProcessor();
      AggReconSettingVO aggBill = (AggReconSettingVO)processor.fromExtBillCard(billCard);
      IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);

      try {
         this.dealExcludesOrgAndDefCol(billCard, aggBill);
         AggReconSettingVO e = reconSettingService.saveBill(aggBill);
         if(e != null) {
            billCard = this.afterProcess(billCard.getPageid(), e);
         }
      } catch (Exception var7) {
         ExceptionUtils.wrapException(var7);
      }

      return billCard;
   }

   private ExtBillCard afterProcess(String pageid, AggReconSettingVO vo) throws BusinessException {
      ExtBillCardOperator operator = new ExtBillCardOperator(pageid);
      operator.setTransFlag(Boolean.TRUE.booleanValue());
      ExtBillCard card = operator.toCard(vo);
      RcpSettingCardUtil.afterToCard(card, vo);
      return card;
   }

   private void dealExcludesOrgAndDefCol(ExtBillCard billCard, AggReconSettingVO newReconSetting) {
      if(!Objects.isNull(newReconSetting)) {
         Grid[] allBody = billCard.getAllBodys();
         if(ArrayUtils.isNotEmpty(allBody)) {
            Grid[] var4 = allBody;
            int var5 = allBody.length;

            for(int var6 = 0; var6 < var5; ++var6) {
               Grid grid = var4[var6];
               GridModel model = grid.getModel();
               if(Objects.nonNull(model) && ArrayUtils.isNotEmpty(model.getRows())) {
                  ArrayList defColVOList;
                  Row[] rows;
                  Row[] var11;
                  int var12;
                  int var13;
                  Row row;
                  Map values;
                  if("exclude_org".equals(model.getAreacode())) {
                     defColVOList = new ArrayList();
                     rows = model.getRows();
                     var11 = rows;
                     var12 = rows.length;

                     for(var13 = 0; var13 < var12; ++var13) {
                        row = var11[var13];
                        ReconSettingExcludeOrgVO vo = new ReconSettingExcludeOrgVO();
                        values = row.getValues();
                        vo.setDesorgflag(UFBoolean.valueOf((String)((Cell)values.get("desorgflag")).getValue()));
                        vo.setPk_org((String)((Cell)values.get("pk_org")).getValue());
                        vo.setPk_recon_exclude(Objects.nonNull(values.get("pk_recon_exclude"))?(String)((Cell)values.get("pk_recon_exclude")).getValue():null);
                        vo.setPk_reconsetting(Objects.nonNull(values.get("pk_reconsetting"))?(String)((Cell)values.get("pk_reconsetting")).getValue():null);
                        vo.setStatus(2);
                        defColVOList.add(vo);
                     }

                     newReconSetting.setChildren(ReconSettingExcludeOrgVO.class, (ISuperVO[])defColVOList.toArray(new ReconSettingExcludeOrgVO[0]));
                  } else if("def_col".equals(model.getAreacode())) {
                     defColVOList = new ArrayList();
                     rows = model.getRows();
                     var11 = rows;
                     var12 = rows.length;

                     for(var13 = 0; var13 < var12; ++var13) {
                        row = var11[var13];
                        ReconSettingDefColVO var17 = new ReconSettingDefColVO();
                        values = row.getValues();
                        var17.setDesflag(UFBoolean.valueOf((String)((Cell)values.get("desflag")).getValue()));
                        var17.setSeq(Integer.valueOf(Integer.parseInt((String)((Cell)values.get("seq")).getValue())));
                        var17.setPk_defcol((String)((Cell)values.get("pk_defcol")).getValue());
                        var17.setStatus(2);
                        defColVOList.add(var17);
                     }

                     newReconSetting.setChildren(ReconSettingDefColVO.class, (ISuperVO[])defColVOList.toArray(new ReconSettingDefColVO[0]));
                  }
               }
            }
         }

      }
   }
}
