package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import nc.bs.logging.Logger;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.ui.querytemplate.querytree.IQueryScheme;
import nc.vo.fip.reconsetting.PageTypeEnum;
import nc.vo.fip.reconsetting.ReconSettingVO;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.ml.NCLangRes4VoTransl;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.StringUtils;
import nccloud.dto.baseapp.querytree.dataformat.Condition;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.model.PageInfo;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.impl.platform.common.util.CollectionUtils;
import nccloud.pubitf.baseapp.apprbac.IAppAndOrgPermQueryPubService;
import nccloud.pubitf.platform.query.INCCloudQueryService;
import nccloud.web.fip.reconwb.utils.RcpSettingListPageUtil;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;
import nccloud.web.fip.txmsgdata.action.SearchInfo;
import nccloud.web.fip.util.PageUtil;

public class RcpSettingListQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Grid grid = null;
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
      if(!Objects.isNull(info) && !Objects.isNull(info.getQueryInfo()) && !Objects.isNull(info.getQueryInfo().getQuerycondition())) {
         PageTypeEnum pageTypeEnum = PageTypeEnum.getPageType(info.getPageType());
         INCCloudQueryService queryService = (INCCloudQueryService)ServiceLocator.find(INCCloudQueryService.class);
         IQueryScheme scheme = queryService.convertCondition(info.getQueryInfo());
         IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);

         try {
            List e = this.getPermOrgList(info, pageTypeEnum);
            ReconSettingVO[] reconSettings = reconSettingService.findReconSettingList(scheme, pageTypeEnum, e);
            ArrayList pks = new ArrayList();
            HashMap pkMap = new HashMap();
            ReconSettingVO[] var13 = reconSettings;
            int var14 = reconSettings.length;

            for(int var15 = 0; var15 < var14; ++var15) {
               ReconSettingVO vo = var13[var15];
               pks.add(vo.getPk_reconsetting().trim());
               pkMap.put(vo.getPk_reconsetting(), vo);
            }

            if(CollectionUtils.isNotEmpty(pks)) {
               grid = this.toPageGrid(reconSettings, info, pks);
               RcpSettingListPageUtil.dealReconDimAndExcludeOrg(grid, pkMap);
            }
         } catch (Exception var17) {
            ExceptionUtils.wrapException(var17);
         }

         return grid;
      } else {
         return null;
      }
   }

   private Grid toPageGrid(ReconSettingVO[] reconSettings, SearchInfo info, List allPks) {
      GridOperator operator = new GridOperator(info.getPagecode());
      int length = Integer.parseInt(info.getQueryInfo().getPageInfo().getPageSize());
      if(reconSettings.length < length) {
         length = reconSettings.length;
      }

      ArrayList pageVos = new ArrayList(Arrays.asList(reconSettings).subList(0, length));
      operator.setTransFlag(Boolean.TRUE.booleanValue());
      Grid grid = operator.toGrid(pageVos.toArray());
      PageInfo pageInfo = new PageInfo();
      pageInfo.setTotal(allPks.size());
      pageInfo.setPageSize(Integer.parseInt(info.getQueryInfo().getPageInfo().getPageSize()));
      pageInfo.setPageIndex(0);
      pageInfo.setTotalPage(PageUtil.getTotalPage(pageInfo, allPks.size()));
      grid.getModel().setPageinfo(pageInfo);
      grid.getModel().setAllpks((String[])allPks.toArray(new String[0]));
      return grid;
   }

   private List getPermOrgList(SearchInfo info, PageTypeEnum pageTypeEnum) throws BusinessException {
      ArrayList filteredOrgList = new ArrayList();
      if(info != null && info.getQueryInfo() != null && info.getQueryInfo().getQuerycondition() != null) {
         List conditionList = info.getQueryInfo().getQuerycondition().getConditions();
         String moduleId = null;
         String desOrgStr = null;
         if(conditionList != null) {
            Iterator var7 = conditionList.iterator();

            while(var7.hasNext()) {
               Condition condition = (Condition)var7.next();
               if(condition.getField().equals("pk_system_des")) {
                  moduleId = condition.getValue().getFirstvalue();
               } else if(condition.getField().equals("pk_org_des")) {
                  desOrgStr = condition.getValue().getFirstvalue();
               }
            }
         }

         if(pageTypeEnum == PageTypeEnum.ORG) {
            filteredOrgList.addAll(this.getPermOrg(info.getAppCode(), moduleId, desOrgStr));
         }

         return filteredOrgList;
      } else {
         return filteredOrgList;
      }
   }

   private List getPermOrg(String strAppCode, String moduleIds, String desOrgStr) throws BusinessException {
      ArrayList filteredOrgList = new ArrayList();
      String strPk_group = SessionContext.getInstance().getClientInfo().getPk_group();
      String strPk_user = SessionContext.getInstance().getClientInfo().getUserid();
      List systemSingleVOList;
      if(StringUtils.isBlank(moduleIds)) {
         systemSingleVOList = ReconSystemUtil.getAllReconSystem("N");
      } else {
         String[] orgTypeList = moduleIds.split(",");
         String[] hasPermOrg = new String[orgTypeList.length];
         Arrays.fill(hasPermOrg, "N");
         systemSingleVOList = ReconSystemUtil.getOnlyReconSystem(orgTypeList, hasPermOrg);
      }

      ArrayList var16 = new ArrayList();
      Iterator var17 = systemSingleVOList.iterator();

      while(var17.hasNext()) {
         ReconSystemSingleVO desOrgArray = (ReconSystemSingleVO)var17.next();
         var16.add(desOrgArray.getReconsystem().getOrgtype());
      }

      if(!var16.isEmpty()) {
         HashSet var18 = new HashSet();
         Iterator var19 = var16.iterator();

         while(var19.hasNext()) {
            String orgType = (String)var19.next();
            String[] orgs = null;

            try {
               orgs = ((IAppAndOrgPermQueryPubService)ServiceLocator.find(IAppAndOrgPermQueryPubService.class)).queryUserPermOrgPksByAppAndWithOrgTypesFilter(strPk_user, strAppCode, new String[]{orgType}, strPk_group);
            } catch (BusinessException var15) {
               Logger.error(var15.getMessage(), var15);
            }

            if(orgs != null && orgs.length > 0) {
               Collections.addAll(var18, orgs);
            }
         }

         if(!var18.isEmpty()) {
            if(StringUtils.isNoneBlank(new CharSequence[]{desOrgStr})) {
               String[] var20 = desOrgStr.split(",");
               String[] var21 = var20;
               int var22 = var20.length;

               for(int ex = 0; ex < var22; ++ex) {
                  String org = var21[ex];
                  if(var18.contains(org)) {
                     filteredOrgList.add(org);
                  }
               }

               if(filteredOrgList.isEmpty()) {
                  throw new BusinessException(NCLangRes4VoTransl.getNCLangRes().getStrByID("1017prv_0", "01017prv-0049"));
               }
            } else {
               filteredOrgList.addAll(var18);
            }
         }
      }

      return filteredOrgList;
   }
}
