package nccloud.web.fip.reconwb.action;

import java.util.HashMap;
import java.util.Objects;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.vo.fip.reconsetting.ReconSettingVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridOperator;
import nccloud.web.fip.reconwb.utils.RcpSettingListPageUtil;
import nccloud.web.fip.txmsgdata.action.SearchInfo;

public class RcpSettingListPageQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Grid grid = null;
      IJson json = JsonFactory.create();
      SearchInfo info = (SearchInfo)json.fromJson(request.read(), SearchInfo.class);
      if(Objects.isNull(info)) {
         return null;
      } else {
         IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);

         try {
            ReconSettingVO[] e = reconSettingService.findReconSettingListByPkForListPage(info.getPk_bills());
            HashMap pkMap = new HashMap();
            ReconSettingVO[] operator = e;
            int var9 = e.length;

            for(int var10 = 0; var10 < var9; ++var10) {
               ReconSettingVO vo = operator[var10];
               pkMap.put(vo.getPk_reconsetting(), vo);
            }

            GridOperator var13 = new GridOperator(info.getPagecode());
            grid = var13.toGrid(e);
            RcpSettingListPageUtil.dealReconDimAndExcludeOrg(grid, pkMap);
         } catch (Exception var12) {
            ExceptionUtils.wrapException(var12);
         }

         return grid;
      }
   }
}
