package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nc.itf.fip.reconsetting.IReconSettingService;
import nccloud.commons.collections.CollectionUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class RcpSettingDeleteAction implements ICommonAction {

   public Object doAction(IRequest request) {
      IJson json = JsonFactory.create();
      List delList = (List)json.fromJson(request.read(), List.class);
      if(CollectionUtils.isNotEmpty(delList)) {
         IReconSettingService reconSettingService = (IReconSettingService)ServiceLocator.find(IReconSettingService.class);
         ArrayList reconSettingPKList = new ArrayList();
         Iterator e = delList.iterator();

         while(e.hasNext()) {
            Object ob = e.next();
            Map map = (Map)ob;
            reconSettingPKList.add((String)map.get("pk_bill"));
         }

         try {
            reconSettingService.deleteBills((String[])reconSettingPKList.toArray(new String[0]));
         } catch (Exception var9) {
            ExceptionUtils.wrapException(var9);
         }
      }

      return null;
   }
}
