package nccloud.web.fip.reconwb.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.itf.fip.pub.IModuleService;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.fip.reconwb.ReconSystemSingleVO.SingleSystemVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;
import org.apache.commons.lang3.ArrayUtils;

public class OrgrefQueryByModuleIdAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
      List moduleIds = (List)paramMap.get("moduleid");
      String isSrc = (String)paramMap.get("isSrc");

      try {
         ReconSystemSingleVO[] e = ReconSystemUtil.getReconSystemVOs((String[])moduleIds.toArray(new String[0]), isSrc);
         HashSet orgRefSet = new HashSet();
         HashSet orgTypeSet = new HashSet();
         if(ArrayUtils.isNotEmpty(e)) {
            ReconSystemSingleVO[] resultMap = e;
            int var9 = e.length;

            for(int var10 = 0; var10 < var9; ++var10) {
               ReconSystemSingleVO systemVO = resultMap[var10];
               SingleSystemVO singleSystemVO = systemVO.getReconsystem();
               if(singleSystemVO != null) {
                  orgRefSet.add(singleSystemVO.getOrgref());
                  orgTypeSet.add(singleSystemVO.getOrgtype());
               }
            }
         }

         HashMap var14 = new HashMap();
         if("Y".equals(isSrc)) {
            var14.putAll(((IModuleService)ServiceLocator.find(IModuleService.class)).getBillTypeByModuleIds((String[])moduleIds.toArray(new String[0])));
         } else {
            var14.put("orgtype", orgTypeSet.size() == 1?((String[])orgTypeSet.toArray(new String[0]))[0]:null);
         }

         var14.put("orgref", orgRefSet.size() == 1?((String[])orgRefSet.toArray(new String[0]))[0]:null);
         return var14;
      } catch (Exception var13) {
         ExceptionUtils.wrapException(var13);
         return null;
      }
   }
}
