package nccloud.web.fip.reconwb.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nc.itf.fip.pub.IModuleService;
import nc.vo.fip.reconwb.ReconSystemSingleVO;
import nc.vo.fip.reconwb.ReconSystemSingleVO.SingleSystemVO;
import nccloud.commons.collections.CollectionUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.web.fip.reconwb.utils.ReconSystemUtil;
import org.apache.commons.lang3.ArrayUtils;

public class OrgRefQueryByPkAction implements ICommonAction {

   public Object doAction(IRequest request) {
      Map paramMap = (Map)JsonFactory.create().fromJson(request.read(), Map.class);
      List modulePksList = (List)paramMap.get("modulePks");
      List isSrcList = (List)paramMap.get("isSrc");

      try {
         ArrayList e = new ArrayList();
         if(CollectionUtils.isNotEmpty(modulePksList)) {
            for(int i = 0; i < modulePksList.size(); ++i) {
               String modulePks = (String)modulePksList.get(i);
               String isSrc = (String)isSrcList.get(i);
               ReconSystemSingleVO[] systemVOs = ReconSystemUtil.getReconSystemVOs(modulePks.split(","), isSrc);
               HashSet orgRefSet = new HashSet();
               HashSet orgTypeSet = new HashSet();
               ArrayList moduleIds = new ArrayList();
               if(ArrayUtils.isNotEmpty(systemVOs)) {
                  ReconSystemSingleVO[] resultMap = systemVOs;
                  int var14 = systemVOs.length;

                  for(int var15 = 0; var15 < var14; ++var15) {
                     ReconSystemSingleVO systemVO = resultMap[var15];
                     SingleSystemVO singleSystemVO = systemVO.getReconsystem();
                     if(singleSystemVO != null) {
                        orgRefSet.add(singleSystemVO.getOrgref());
                        orgTypeSet.add(singleSystemVO.getOrgtype());
                        moduleIds.add(singleSystemVO.getModuleid());
                     }
                  }
               }

               Object var19 = new HashMap();
               if("Y".equals(isSrc)) {
                  if(CollectionUtils.isNotEmpty(moduleIds)) {
                     var19 = ((IModuleService)ServiceLocator.find(IModuleService.class)).getBillTypeByModuleIds((String[])moduleIds.toArray(new String[0]));
                     ((Map)var19).put("moduleIds", String.join(",", moduleIds));
                  }
               } else {
                  ((Map)var19).put("orgtype", orgTypeSet.size() == 1?((String[])orgTypeSet.toArray(new String[0]))[0]:null);
               }

               ((Map)var19).put("isSrc", isSrc);
               ((Map)var19).put("orgref", orgRefSet.size() == 1?((String[])orgRefSet.toArray(new String[0]))[0]:null);
               e.add(var19);
            }
         }

         return e;
      } catch (Exception var18) {
         ExceptionUtils.wrapException(var18);
         return null;
      }
   }
}
