package nccloud.web.fip.reconwb.action;

import java.util.Map;
import nc.itf.fip.reconexe.IFIPReportDrillService;
import nc.vo.pub.BusinessException;
import nccloud.dto.baseapp.querytree.dataformat.QueryTreeFormatVO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class FipDrillQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String jsonstr = request.read();
      if(jsonstr == null || jsonstr.trim().length() == 0) {
         String gson = "params is empty";
         ExceptionUtils.wrapBusinessException(gson);
      }

      IJson gson1 = JsonFactory.create();
      QueryTreeFormatVO queryTreeVO = (QueryTreeFormatVO)gson1.fromJson(jsonstr, QueryTreeFormatVO.class);
      Map jsonMap = (Map)gson1.fromJson(jsonstr, Map.class);
      IFIPReportDrillService service = (IFIPReportDrillService)ServiceLocator.find(IFIPReportDrillService.class);
      Map pageInfo = null;

      try {
         pageInfo = service.getUrlByConditions(queryTreeVO, jsonMap);
      } catch (BusinessException var9) {
         ExceptionUtils.wrapException(var9);
      }

      return pageInfo;
   }
}
