package nccloud.web.fip.reconwb.action;

import java.util.Map;
import nc.itf.fip.reconsetting.IReconSettingService;
import nc.vo.fip.reconsetting.AggReconSettingVO;
import nc.vo.pub.BusinessException;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;

public class FipCheckDesOrgAndSettingNumAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         Map dataMap = (Map)JsonFactory.create().fromJson(e, Map.class);
         String pk_system_des = (String)dataMap.get("pk_system_des");
         String pk_system_src = (String)dataMap.get("pk_system_src");
         String desOrgPks = (String)dataMap.get("desOrgPks");
         String[] desOrgPkArr = desOrgPks.split(",");
         AggReconSettingVO[] aggSettingVOS = ((IReconSettingService)ServiceLocator.find(IReconSettingService.class)).querySettingBySysAndOrg(pk_system_des, new String[]{pk_system_src}, desOrgPkArr);
         if(ArrayUtils.isNotEmpty(aggSettingVOS) && desOrgPkArr.length * aggSettingVOS.length > 1000) {
            return Boolean.TRUE;
         }
      } catch (BusinessException var9) {
         ExceptionUtils.wrapException(var9);
      }

      return Boolean.FALSE;
   }
}
