package nccloud.web.fip.reconwb.action;

import java.util.HashMap;
import java.util.Map;
import nc.itf.fip.reconexe.IAccountReportWebService;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFDate;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.json.JsonFactory;

public class BookBusiDateQueryAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      Map varMap = (Map)JsonFactory.create().fromJson(json, Map.class);
      if(varMap.get("pk_accountingbook") == null) {
         return null;
      } else {
         try {
            UFDate e = new UFDate(SessionContext.getInstance().getClientInfo().getBizDateTime());
            HashMap paramMap = new HashMap();
            paramMap.put("bizDate", e);
            paramMap.put("pk_accountingbook", varMap.get("pk_accountingbook"));
            paramMap.put("appcode", SessionContext.getInstance().getAppcode());
            Map info = ((IAccountReportWebService)ServiceLocator.find(IAccountReportWebService.class)).queryBusiDate(paramMap);
            return info;
         } catch (BusinessException var7) {
            ExceptionUtils.wrapException(var7);
            return null;
         }
      }
   }
}
