package nccloud.web.fip.preview.action;

import java.util.List;
import java.util.Map;
import nc.itf.fip.opreatinglog.IBusiTypeService;
import nc.itf.fip.opreatinglog.IFipInterfaceService;
import nc.itf.fip.preview.IFipPreviewDesBillService;
import nc.vo.fip.preview.FipPreviewResultDataVO;
import nc.vo.fip.service.FipMessageVO;
import nccloud.base.exception.ExceptionUtils;
import nccloud.commons.collections.CollectionUtils;
import nccloud.commons.lang.ArrayUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.grid.GridOperator;

public class FipPreviewDesBillAction implements ICommonAction {

   private static String MESSAGEVO = "messagevo";
   private static String SRCBILLTYPE = "srcbilltype";
   private static String PK_GROUP = "pk_group";
   private static String PK_BIIITYPE = "pk_billtype";


   public Object doAction(IRequest request) {
      String str = request.read();
      IJson json = JsonFactory.create();
      FipMessageVO[][] vos = null;

      try {
         Map ex = (Map)json.fromJson(str, Map.class);
         if(ex != null && ex.size() > 0) {
            List list = (List)ex.get(MESSAGEVO);
            if(CollectionUtils.isNotEmpty(list)) {
               String pk_group = (String)((Map)list.get(0)).get(PK_GROUP);
               String pk_billtype = (String)((Map)list.get(0)).get(PK_BIIITYPE);
               Map dataMap = ((IFipInterfaceService)ServiceLocator.find(IFipInterfaceService.class)).getPreviewVocherService(pk_group, (String)ex.get(SRCBILLTYPE), ex);
               if(dataMap != null && dataMap.size() > 0) {
                  vos = (FipMessageVO[][])dataMap.get(MESSAGEVO);
                  FipPreviewResultDataVO[] combineVos = ((IFipPreviewDesBillService)ServiceLocator.find(IFipPreviewDesBillService.class)).queryPreviewData(vos, pk_group, pk_billtype);
                  if(ArrayUtils.isNotEmpty(combineVos)) {
                     combineVos = (FipPreviewResultDataVO[])((IBusiTypeService)ServiceLocator.find(IBusiTypeService.class)).queryByVOs(combineVos);
                     GridOperator oper = new GridOperator("10170410_1017041001");
                     return oper.toGrid(combineVos);
                  }
               }
            }
         }
      } catch (Exception var12) {
         ExceptionUtils.wrapException(var12);
      }

      return null;
   }

}
