package nccloud.web.fip.pfxxsysconf.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import nc.itf.org.IGroupQryService;
import nc.pubitf.rbac.IUserPubService;
import nc.vo.fip.pub.FipLangTool;
import nc.vo.fip.pub.FipStringUtils;
import nc.vo.org.GroupVO;
import nc.vo.pub.BusinessException;
import nc.vo.sm.UserVO;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;

public class TranslateUtil {

   public static void translate(BillCard billcard) throws BusinessException {
      List rows = billcard.getHead().getModel().getListRows();
      translateGroup(rows);
      translateUser(rows);
   }

   private static void translateUser(List rows) throws BusinessException {
      HashMap userMap = new HashMap();
      Iterator users = rows.iterator();

      Cell creator;
      while(users.hasNext()) {
         Row row = (Row)users.next();
         Cell row1 = row.getCell("creator");
         if(notEmptyCellValue(row1)) {
            userMap.put(row1.getValue().toString(), (Object)null);
         }

         creator = row.getCell("modifier");
         if(notEmptyCellValue(creator)) {
            userMap.put(creator.getValue().toString(), (Object)null);
         }
      }

      if(!userMap.isEmpty()) {
         UserVO[] var9 = ((IUserPubService)ServiceLocator.find(IUserPubService.class)).getUsersByPKs((String[])userMap.keySet().toArray(new String[0]));
         if(var9 != null && var9.length > 0) {
            UserVO[] var10 = var9;
            int var12 = var9.length;

            for(int var14 = 0; var14 < var12; ++var14) {
               UserVO modifier = var10[var14];
               if(modifier != null) {
                  String userid = modifier.getCuserid();
                  String name = FipLangTool.getCurrLangValue(modifier, "user_name");
                  userMap.put(userid, name);
               }
            }
         }

         Iterator var11 = rows.iterator();

         while(var11.hasNext()) {
            Row var13 = (Row)var11.next();
            creator = var13.getCell("creator");
            Cell var15 = var13.getCell("modifier");
            if(notEmptyCellValue(creator) && !FipStringUtils.isEmpty((String)userMap.get(creator.getValue().toString()))) {
               creator.setDisplay((String)userMap.get(creator.getValue().toString()));
            }

            if(notEmptyCellValue(var15) && !FipStringUtils.isEmpty((String)userMap.get(var15.getValue().toString()))) {
               var15.setDisplay((String)userMap.get(var15.getValue().toString()));
            }
         }
      }

   }

   private static void translateGroup(List rows) throws BusinessException {
      HashMap groupMap = new HashMap();
      Iterator groups = rows.iterator();

      while(groups.hasNext()) {
         Row row = (Row)groups.next();
         Cell row1 = row.getCell("pk_org");
         if(notEmptyCellValue(row1)) {
            groupMap.put(row1.getValue().toString(), (Object)null);
         }
      }

      if(!groupMap.isEmpty()) {
         GroupVO[] var9 = ((IGroupQryService)ServiceLocator.find(IGroupQryService.class)).queryGroupVOsByPKS((String[])groupMap.keySet().toArray(new String[0]));
         if(var9 != null && var9.length > 0) {
            GroupVO[] var10 = var9;
            int var12 = var9.length;

            for(int org = 0; org < var12; ++org) {
               GroupVO group = var10[org];
               if(group != null) {
                  String pk = group.getPk_group();
                  String name = FipLangTool.getCurrLangValue(group, "name");
                  groupMap.put(pk, name);
               }
            }
         }

         Iterator var11 = rows.iterator();

         while(var11.hasNext()) {
            Row var13 = (Row)var11.next();
            Cell var14 = var13.getCell("pk_org");
            if(notEmptyCellValue(var14) && !FipStringUtils.isEmpty((String)groupMap.get(var14.getValue().toString()))) {
               var14.setDisplay((String)groupMap.get(var14.getValue().toString()));
            }
         }
      }

   }

   private static boolean notEmptyCellValue(Cell cell) {
      return cell != null && cell.getValue() != null && !FipStringUtils.isEmpty(cell.getValue().toString());
   }
}
