package nccloud.web.fip.pfxxsysconf.action;

import nc.vo.fip.pfxxsysconf.PfxxSysConfOrgVO;
import nc.vo.fip.pfxxsysconf.PfxxSysConfVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.BillCardConvertProcessor;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.billcard.SpecilAggBill;
import nccloud.pubitf.fip.pfxxsysconf.IWebPfxxSysConfService;
import nccloud.web.fip.pfxxsysconf.action.TranslateUtil;

public class PfxxsysconfSaveAction implements ICommonAction {

   public Object doAction(IRequest request) {
      BillCard billcard = null;
      String json = request.read();
      BillCard oldBillCard = (BillCard)JsonFactory.create().fromJson(json, BillCard.class);

      try {
         ((Row)oldBillCard.getHead().getModel().getListRows().get(0)).removeCell("pfxxsysconforg");
         BillCardConvertProcessor e = new BillCardConvertProcessor();
         SpecilAggBill bill = (SpecilAggBill)e.fromBillCard(oldBillCard);
         PfxxSysConfVO cardVO = (PfxxSysConfVO)bill.getHead();
         cardVO.setPfxxsysconforg((PfxxSysConfOrgVO[])bill.getBodys());
         PfxxSysConfVO returnVO = ((IWebPfxxSysConfService)ServiceLocator.find(IWebPfxxSysConfService.class)).save(cardVO);
         BillCardOperator operator = new BillCardOperator(oldBillCard.getPageid());
         SpecilAggBill specilAggBill = new SpecilAggBill();
         specilAggBill.setHead(returnVO);
         specilAggBill.setBodys(returnVO.getPfxxsysconforg());
         billcard = operator.toCard(specilAggBill);
         TranslateUtil.translate(billcard);
         if(oldBillCard.getBody() != null && billcard.getBody() != null) {
            Row[] oldRows = oldBillCard.getBody().getModel().getRows();
            Row[] newRows = billcard.getBody().getModel().getRows();
            int j = 0;

            for(int i = 0; i < oldRows.length; ++i) {
               if(3 != oldRows[i].getStatus().intValue()) {
                  newRows[j].setRowid(oldRows[i].getRowid());
                  ++j;
               }
            }
         }
      } catch (BusinessException var15) {
         ExceptionUtils.wrapException(var15);
      }

      return billcard;
   }
}
