package nccloud.web.fip.pfxxsysconf.action;

import java.util.Map;
import nc.pubitf.fip.pfxxsysconf.IPfxxSysConfQueryService;
import nc.vo.fip.pfxxsysconf.PfxxSysConfVO;
import nc.vo.pub.BusinessException;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.ui.pattern.billcard.BillCard;
import nccloud.framework.web.ui.pattern.billcard.BillCardOperator;
import nccloud.framework.web.ui.pattern.billcard.SpecilAggBill;
import nccloud.web.fip.pfxxsysconf.action.TranslateUtil;

public class PfxxsysconfQueryCardAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      Map param = (Map)JsonFactory.create().fromJson(json, Map.class);

      try {
         String e = (String)param.get("pagecode");
         String pk = (String)param.get("pk_pfxxsysconf");
         IPfxxSysConfQueryService service = (IPfxxSysConfQueryService)ServiceLocator.find(IPfxxSysConfQueryService.class);
         PfxxSysConfVO vo = service.queryPfxxSysConfVO(pk);
         if(vo != null) {
            BillCardOperator operator = new BillCardOperator(e);
            SpecilAggBill specilAggBill = this.getSpecilAggBill(vo);
            BillCard result = operator.toCard(specilAggBill);
            TranslateUtil.translate(result);
            return result;
         }
      } catch (BusinessException var11) {
         ExceptionUtils.wrapException(var11);
      }

      return null;
   }

   private SpecilAggBill getSpecilAggBill(PfxxSysConfVO vo) {
      if(vo == null) {
         return null;
      } else {
         SpecilAggBill specilAggBill = new SpecilAggBill();
         specilAggBill.setHead(vo);
         specilAggBill.setBodys(vo.getPfxxsysconforg());
         return specilAggBill;
      }
   }
}
