package nccloud.web.fip.pfxxsysconf.action;

import java.util.List;
import java.util.Map;
import nc.vo.fip.pfxxsysconf.PfxxSysConfVO;
import nc.vo.pub.BusinessException;
import nc.vo.pub.lang.UFBoolean;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.framework.web.ui.pattern.grid.GridFormulaHandler;
import nccloud.pubitf.fip.pfxxsysconf.IWebPfxxSysConfService;

public class PfxxsysconfEnableAction implements ICommonAction {

   public Object doAction(IRequest request) {
      String json = request.read();
      Map param = (Map)JsonFactory.create().fromJson(json, Map.class);

      try {
         String e = (String)param.get("pagecode");
         boolean enable = UFBoolean.valueOf(param.get("enable").toString()).booleanValue();
         List pks = (List)param.get("pk_pfxxsysconf");
         IWebPfxxSysConfService service = (IWebPfxxSysConfService)ServiceLocator.find(IWebPfxxSysConfService.class);
         PfxxSysConfVO[] vos = service.enable((String[])pks.toArray(new String[pks.size()]), enable);
         if(vos != null && vos.length != 0) {
            GridConvertProcessor processor = new GridConvertProcessor();
            Grid grid = processor.convert(e, vos);
            GridFormulaHandler handler = new GridFormulaHandler(grid);
            handler.handleLoadFormula();
            Translator translator = new Translator();
            translator.translate(grid);
            return grid;
         } else {
            return null;
         }
      } catch (BusinessException var13) {
         ExceptionUtils.wrapException(var13);
         return null;
      }
   }
}
