package nccloud.web.fip.orgrule.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import nc.itf.fip.orgrule.IOrgRuleService;
import nc.vo.fip.orgrule.OrgRuleVO;
import nc.vo.pub.BusinessException;
import nccloud.dto.fip.docview.DocTranslateDTO;
import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.Conditions;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.container.SessionContext;
import nccloud.framework.web.convert.translate.Translator;
import nccloud.framework.web.json.JsonFactory;
import nccloud.framework.web.processor.template.GridConvertProcessor;
import nccloud.framework.web.ui.model.row.Cell;
import nccloud.framework.web.ui.model.row.Row;
import nccloud.framework.web.ui.pattern.grid.Grid;
import nccloud.pubitf.fip.busiunit.IQueryBusiunitTreeService;
import nccloud.pubitf.fip.docview.IDocViewListQuery;
import nccloud.pubitf.fip.transtemplate.ITransTemplateService;

public class QueryOrgruleAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         String src_billtype = info.getOid();
         String des_billtype = ((Conditions)info.getConditions().get(0)).getValue().getFirstvalue();
         String pk_group = SessionContext.getInstance().getClientInfo().getPk_group();
         OrgRuleVO vo = new OrgRuleVO();
         if(info.getOid() != null) {
            vo.setDes_billtype(des_billtype);
            vo.setPk_group(pk_group);
            vo.setSrc_billtype(src_billtype);
         }

         OrgRuleVO[] vos = ((IOrgRuleService)ServiceLocator.find(IOrgRuleService.class)).queryByVO(vo, Boolean.valueOf(true));
         if(vos == null) {
            return null;
         } else {
            GridConvertProcessor processor = new GridConvertProcessor();
            Grid grid = processor.convert(info.getPageCode(), vos);
            Translator translator = new Translator();
            translator.translate(grid);
            this.dealDisplay(grid, vos, pk_group, src_billtype, des_billtype);
            return grid;
         }
      } catch (BusinessException var13) {
         ExceptionUtils.wrapException(var13);
         return null;
      }
   }

   public void dealDisplay(Grid grid, OrgRuleVO[] vos, String pk_group, String src_billtype, String des_billtype) {
      Row[] headRows = grid.getModel().getRows();
      if(headRows != null) {
         HashMap valueMap = new HashMap();

         for(int i = 0; i < vos.length; ++i) {
            valueMap.put("factorformula", vos[i].getFactorformula());
            valueMap.put("orgformula", vos[i].getOrgformula());
            valueMap.put("factor1", vos[i].getFactor1());
            ITransTemplateService translateService = (ITransTemplateService)ServiceLocator.find(ITransTemplateService.class);
            Map displayShowMap = null;

            try {
               displayShowMap = translateService.convertTemplateHeadData(valueMap, pk_group, (String)null, src_billtype, des_billtype, (String)null);
            } catch (BusinessException var19) {
               ExceptionUtils.wrapException(var19);
            }

            Map docNameMap = null;
            DocTranslateDTO params = new DocTranslateDTO();
            String entityid = ((IQueryBusiunitTreeService)ServiceLocator.find(IQueryBusiunitTreeService.class)).getEntityid(src_billtype);
            params.setId(entityid);
            HashSet pks = new HashSet();
            pks.add((String)valueMap.get("factor1"));
            params.setPks(pks);
            if(displayShowMap != null && displayShowMap.get("factor1") != null) {
               try {
                  docNameMap = ((IDocViewListQuery)ServiceLocator.find(IDocViewListQuery.class)).getDocNameByPKForShow(new DocTranslateDTO[]{params});
               } catch (BusinessException var18) {
                  ExceptionUtils.wrapBusinessException(var18.getMessage());
               }
            }

            Cell expmessage1 = headRows[i].getCell("factorformula");
            if(expmessage1 != null && expmessage1.getValue() != null) {
               expmessage1.setDisplay((String)displayShowMap.get("factorformula"));
            }

            Cell expmessage2 = headRows[i].getCell("orgformula");
            if(expmessage2 != null && expmessage2.getValue() != null) {
               expmessage2.setDisplay((String)displayShowMap.get("orgformula"));
            }

            Cell expmessage3 = headRows[i].getCell("factor1");
            if(expmessage3 != null && expmessage3.getValue() != null && displayShowMap.get("factor1") != null) {
               docNameMap.setDisplay((String)params.getId().get((String)valueMap.get("factor1")));
            }
         }
      }

   }
}
