package nccloud.web.fip.orgrule.action;

import nccloud.framework.core.exception.ExceptionUtils;
import nccloud.framework.core.json.IJson;
import nccloud.framework.querytemplate.candidate.QueryTemplateInfo4Web;
import nccloud.framework.service.ServiceLocator;
import nccloud.framework.web.action.itf.ICommonAction;
import nccloud.framework.web.container.IRequest;
import nccloud.framework.web.json.JsonFactory;
import nccloud.pubitf.fip.orgrule.IQueryOrgruleTreeService;

public class OrgruleQueryColumnAction implements ICommonAction {

   public Object doAction(IRequest request) {
      try {
         String e = request.read();
         String column = null;
         IJson json = JsonFactory.create();
         QueryTemplateInfo4Web info = (QueryTemplateInfo4Web)json.fromJson(e, QueryTemplateInfo4Web.class);
         if(info.getOid() != null) {
            column = ((IQueryOrgruleTreeService)ServiceLocator.find(IQueryOrgruleTreeService.class)).getChangColumn(info.getOid());
         }

         return column != null?column:"undefined";
      } catch (Exception var6) {
         ExceptionUtils.wrapException(var6);
         return null;
      }
   }
}
